package com.hp.hpl.sparta.xpath;

import java.io.*;
import java.util.*;

public class XPath
{

	static private final int ASSERTION = 0;

	private XPath(boolean isAbsolute, Step[] steps)
	{
		for (int i = 0; i < steps.length; ++i)
			steps_.addElement(steps[i]);
		absolute_ = isAbsolute;
		string_ = null;
	}

	private XPath(String s) throws XPathException
	/* , IOException */ {
		// StringReader not supported in J2ME
		this(s, new InputStreamReader(new ByteArrayInputStream(s.getBytes())));
	}

	private XPath(String s, Reader reader) throws XPathException
	{
		try
		{
			string_ = s;
			SimpleStreamTokenizer toks = new SimpleStreamTokenizer(reader);
			toks.ordinaryChar('/'); // '/' is not a comment
			toks.ordinaryChar('.'); // '.' is not a part of a number
			toks.wordChars(':', ':'); // Allow namespaces
			toks.wordChars('_', '_'); // Allow namespaces

			boolean multiLevel;
			if (toks.nextToken() == '/')
			{
				absolute_ = true;
				if (toks.nextToken() == '/')
				{
					multiLevel = true;
					toks.nextToken();
				}
				else
					multiLevel = false;
			}
			else
			{
				absolute_ = false;
				multiLevel = false;
			}
			// current token is first token of node_test production
			steps_.push(new Step(this, multiLevel, toks));
			// current token is token after last token of step production

			while (toks.ttype == '/')
			{
				if (toks.nextToken() == '/')
				{
					multiLevel = true;
					toks.nextToken();
				}
				else
					multiLevel = false;
				// current token is first token of node_test production
				steps_.push(new Step(this, multiLevel, toks));
				// current token is token after last token of step production
			}

			if (toks.ttype != SimpleStreamTokenizer.TT_EOF) throw new XPathException(this, "at end of XPATH expression", toks, "end of expression");
		}
		catch (IOException e)
		{
			throw new XPathException(this, e);
		}
		if (ASSERTION >= 2) if (!toString().equals(generateString())) throw new Error("Postcondition failed");
	}

	public String toString()
	{
		if (string_ == null) string_ = generateString();
		return string_;
	}

	private String generateString()
	{
		StringBuffer result = new StringBuffer();
		boolean first = true;
		for (Enumeration i = steps_.elements(); i.hasMoreElements();)
		{
			Step step = (Step) i.nextElement();
			if (!first || absolute_)
			{
				result.append('/');
				if (step.isMultiLevel()) result.append('/');
			}
			result.append(step.toString());
			first = false;
		}
		return result.toString();
	}

	public boolean isAbsolute()
	{
		return absolute_;
	}

	public boolean isStringValue()
	{
		Step lastStep = (Step) steps_.peek();
		return lastStep.isStringValue();
	}

	public Enumeration getSteps()
	{
		return steps_.elements();
	}

	public String getIndexingAttrName() throws XPathException
	{
		Step step = (Step) steps_.peek();
		BooleanExpr predicate = step.getPredicate();
		if (!(predicate instanceof AttrExistsExpr)) throw new XPathException(this, "has no indexing attribute name (must end with predicate of the form [@attrName]");
		return ((AttrExistsExpr) predicate).getAttrName();
	}

	public String getIndexingAttrNameOfEquals() throws XPathException
	{
		Step step = (Step) steps_.peek();
		BooleanExpr predicate = step.getPredicate();
		if (predicate instanceof AttrEqualsExpr) return ((AttrEqualsExpr) predicate).getAttrName();
		else
			return null;
	}

	public Object clone()
	{
		Step[] steps = new Step[steps_.size()];
		Enumeration step = steps_.elements();
		for (int i = 0; i < steps.length; ++i)
			steps[i] = (Step) step.nextElement();
		return new XPath(absolute_, steps);
	}


	private Stack steps_ = new Stack();

	private/* final (JDK11 problems) */
	boolean absolute_;

	private String string_;

	static public XPath get(String xpathString) throws XPathException // ,
																		 // IOException
	{
		synchronized (cache_)
		{
			XPath result = (XPath) cache_.get(xpathString);
			if (result == null)
			{
				result = new XPath(xpathString);
				cache_.put(xpathString, result);
			}
			return result;
		}
	}

	static public XPath get(boolean isAbsolute, Step[] steps)
	{
		XPath created = new XPath(isAbsolute, steps);
		String xpathString = created.toString();
		synchronized (cache_)
		{
			XPath inCache = (XPath) cache_.get(xpathString);
			if (inCache == null)
			{
				cache_.put(xpathString, created);
				return created;
			}
			else
				return inCache;

		}

	}

	static public boolean isStringValue(String xpathString) throws XPathException, IOException
	{
		return get(xpathString).isStringValue();
	}

	static private Hashtable cache_ = new Hashtable();

}

// $Log: XPath.java,v $
// Revision 1.10 2003/07/18 00:01:42 eobrain
// Make compatiblie with J2ME. For example do not use "new"
// java.util classes.
//
// Revision 1.9 2003/06/19 20:29:04 eobrain
// Add monitoring (in debug mode) to detect when indexing could optimize.
//
// Revision 1.8 2003/05/12 20:08:10 eobrain
// Inconsequential code change to avoid eclipse warning.
//
// Revision 1.7 2003/03/21 00:21:25 eobrain
// Allow underscores in attribute names.
//
// Revision 1.6 2003/01/27 23:30:58 yuhongx
// Replaced Hashtable with HashMap.
//
// Revision 1.5 2003/01/09 01:17:14 yuhongx
// Use JDK1.1 API to make code work with PersonalJava (use addElement()).
//
// Revision 1.4 2002/12/13 22:42:22 eobrain
// Fix javadoc.
//
// Revision 1.3 2002/12/13 18:09:34 eobrain
// Create XPath from a sequence of steps.
//
// Revision 1.2 2002/12/06 23:41:49 eobrain
// Add toString() which returns the original XPath.
//
// Revision 1.1.1.1 2002/08/19 05:04:02 eobrain
// import from HP Labs internal CVS
//
// Revision 1.9 2002/08/18 23:39:27 eob
// Add copyright and other formatting and commenting in preparation for
// release to SourceForge.
//
// Revision 1.8 2002/08/15 05:11:35 eob
// getIndexingAttrName
//
// Revision 1.7 2002/06/21 00:35:19 eob
// Make work with old JDK 1.1.*
//
// Revision 1.6 2002/06/04 05:27:08 eob
// Simplify use of visitor pattern to make code easier to understand.
//
// Revision 1.5 2002/05/23 21:14:51 eob
// Better error reporting.
//
// Revision 1.4 2002/05/10 19:42:48 eob
// Add static isStringValue
//
// Revision 1.3 2002/03/26 05:31:49 eob
// Making contructor private. Adding static factory method to manage
// cache of XPath objects.
//
// Revision 1.2 2002/02/04 22:12:59 eob
// Add boolean property to test whether this xpath returns a string.
//
// Revision 1.1 2002/02/01 01:59:09 eob
// initial
