package net.sourceforge.pinyin4j;

import java.io.FileNotFoundException;
import java.io.IOException;

import com.hp.hpl.sparta.Document;
import com.hp.hpl.sparta.ParseException;
import com.hp.hpl.sparta.Parser;

class GwoyeuRomatzyhResource
{

	private Document pinyinToGwoyeuMappingDoc;

	private void setPinyinToGwoyeuMappingDoc(Document pinyinToGwoyeuMappingDoc)
	{
		this.pinyinToGwoyeuMappingDoc = pinyinToGwoyeuMappingDoc;
	}

	Document getPinyinToGwoyeuMappingDoc()
	{
		return pinyinToGwoyeuMappingDoc;
	}

	private GwoyeuRomatzyhResource()
	{
		initializeResource();
	}

	private void initializeResource()
	{
		try
		{
			final String mappingFileName = "/pinyindb/pinyin_gwoyeu_mapping.xml";
			final String systemId = "";

			// Parse file to DOM Document
			setPinyinToGwoyeuMappingDoc(Parser.parse(systemId, ResourceHelper.getResourceInputStream(mappingFileName)));

		}
		catch (FileNotFoundException ex)
		{
			ex.printStackTrace();
		}
		catch (IOException ex)
		{
			ex.printStackTrace();
		}
		catch (ParseException e)
		{
			e.printStackTrace();
		}
	}

	static GwoyeuRomatzyhResource getInstance()
	{
		return GwoyeuRomatzyhSystemResourceHolder.theInstance;
	}

	private static class GwoyeuRomatzyhSystemResourceHolder
	{
		static final GwoyeuRomatzyhResource theInstance = new GwoyeuRomatzyhResource();
	}
}
