package cicada.authorization;

import org.apache.log4j.Logger;

import cicada.authorization.config.GetUserIdRet;
import cicada.authorization.config.UserSessionService;
import cicada.core.BeanFactory;

public class UserAuthClient
{
	public GetUserIdRet getUserId(String sessionId)
	{
		final Logger log = Logger.getLogger(UserAuthClient.class);

		final UserSessionService.Iface iface = BeanFactory.getBeanByType(UserSessionService.Iface.class);
		try
		{
			if (iface != null)
			{
				GetUserIdRet result = iface.GetUserId(sessionId);
				return result;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			log.error(e);
		}
		return null;
	}
}
