/*
 * Decompiled with CFR 0.152.
 */
package cicada.authorization.zooKeeper;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class AbstractZooKeeper
implements Watcher {
    private static Log log = LogFactory.getLog((String)AbstractZooKeeper.class.getName());
    private static final int SESSION_TIME = 2000;
    protected ZooKeeper zooKeeper;
    protected CountDownLatch countDownLatch = new CountDownLatch(1);

    public void connect(String hosts) throws IOException, InterruptedException {
        this.zooKeeper = new ZooKeeper(hosts, 2000, (Watcher)this);
        this.countDownLatch.await();
    }

    public void process(WatchedEvent event) {
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            this.countDownLatch.countDown();
        }
    }

    public void close() throws InterruptedException {
        this.zooKeeper.close();
    }
}

