/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.suyeer.fastwechat.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import net.oschina.suyeer.basic.util.BDateUtil;
import net.oschina.suyeer.basic.util.BHttpResUtil;
import net.oschina.suyeer.basic.util.BJsonUtil;
import net.oschina.suyeer.basic.util.BasicUtil;
import net.oschina.suyeer.fastwechat.bean.fwpay.FwPrepayBean;
import net.oschina.suyeer.fastwechat.util.ConstUtil;
import net.oschina.suyeer.fastwechat.util.FwBaseUtil;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FwPayUtil {
    private static Logger logger = LoggerFactory.getLogger(FwPayUtil.class);
    private static Date today = new Date();
    private static int orderIndex = 0;

    public static JSONObject getPayParams(FwPrepayBean fwPrepayBean) {
        try {
            FwBaseUtil.checkParams(fwPrepayBean);
            String prepayId = FwPayUtil.getPrepayId(fwPrepayBean);
            if (prepayId == null || prepayId.length() < 10) {
                throw new Exception("\u751f\u6210\u7684 prepayId \u4e0d\u5408\u6cd5!");
            }
            return FwPayUtil.createPackageValue(prepayId);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5fae\u4fe1\u652f\u4ed8\u8d77\u8c03\u53c2\u6570\u5931\u8d25: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static String getPrepayId(FwPrepayBean fwPrepayBean) {
        TreeMap treeMap = (TreeMap)BJsonUtil.changeType((Object)fwPrepayBean, TreeMap.class);
        StringBuilder xmlStr = new StringBuilder();
        xmlStr.append("<xml>\n");
        for (Map.Entry entry : treeMap.entrySet()) {
            xmlStr.append(String.format("<%s>%s</%s>\n", entry.getKey(), entry.getValue(), entry.getKey()));
        }
        xmlStr.append(String.format("<sign>%s</sign>\n</xml>", FwBaseUtil.createSign(treeMap)));
        String result = BHttpResUtil.sendHttpPostRequest((String)"https://api.mch.weixin.qq.com/pay/unifiedorder", (String)xmlStr.toString());
        result = result.replaceAll("<![CDATA[|]]>", "");
        return Jsoup.parse((String)result).select("prepay_id").html();
    }

    private static JSONObject createPackageValue(String prepayId) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("appId", ConstUtil.APP_ID);
        treeMap.put("timeStamp", BDateUtil.getTimestampString());
        treeMap.put("nonceStr", BasicUtil.getNonceStr());
        treeMap.put("package", "prepay_id=" + prepayId);
        treeMap.put("signType", "MD5");
        treeMap.put("paySign", FwBaseUtil.createSign(treeMap));
        treeMap.put("timestamp", treeMap.get("timeStamp"));
        return BJsonUtil.toJSONObject(treeMap);
    }

    public static String getOrderNumber(String preFixString) {
        Date currTime = new Date();
        String currTimeStr = BDateUtil.getShortTimeFormStr((Date)currTime);
        if (orderIndex > 0 && orderIndex < 900000 && BDateUtil.isSameDay((Date)currTime, (Date)today).booleanValue()) {
            ++orderIndex;
        } else {
            today = currTime;
            orderIndex = 1;
        }
        return String.format("%s%s%06d", preFixString, currTimeStr, orderIndex);
    }
}

