package net.oschina.suyeer.fastwechat.util;

import com.alibaba.fastjson.JSONObject;
import net.oschina.suyeer.fastwechat.bean.fwpay.FwPrepayBean;
import net.oschina.suyeer.fastwechat.bean.fwtemplate.FwTemplateBean;
import net.oschina.suyeer.fastwechat.enums.LanguageEnum;

/**
 * Created by jun on 2016/11/29.
 */
public class FwUtil {

    /**
     * User: jun
     * Date: 2016/11/29
     * Desc: 获取全局AccessToken;
     */
    public static String getAccessToken() {
        return FwTokenUtil.getAccessToken();
    }

    /**
     * User: jun
     * Date: 2016/11/29
     * Desc: 获取JsApiTicket;
     */
    public static String getJsApiTicket() {
        return FwTokenUtil.getJsApiTicket();
    }

    /**
     * 用户授权相关, 根据code换取信息
     */
    public static JSONObject getAuthAccessToken(String code) {
        return FwUserUtil.getAuthAccessToken(code);
    }

    /**
     * 用户授权相关, 刷新Token
     */
    public static JSONObject getRefreshToken(String refreshToken) {
        return FwUserUtil.getRefreshToken(refreshToken);
    }

    /**
     * 用户授权相关, 高级授权获取用户详细信息
     *
     * @param accessToken
     * @param openId
     * @return
     */
    public static JSONObject getAuthUserInfoByOath2Api(String accessToken, String openId) {
        return FwUserUtil.getAuthUserInfoByOath2Api(accessToken, openId);
    }

    /**
     * User: jun
     * Date: 2016/11/29
     * Desc: 根据openId获取用户信息, 需要用户关注公众号; 默认中文信息;
     */
    public static JSONObject getUserInfoByOpenId(String openId) {
        return FwUserUtil.getUserInfoByOpenId(openId, LanguageEnum.zh_CN);
    }

    /**
     * User: jun
     * Date: 2016/11/29
     * Desc: 根据openId获取用户信息, 需要用户关注公众号;
     */
    public static JSONObject getUserInfoByOpenId(String openId, LanguageEnum language) {
        return FwUserUtil.getUserInfoByOpenId(openId, language);
    }

    /**
     * 批量获取用户openid,一次可获取10000条
     */
    public static JSONObject getUserOpenIdList() {
        return FwUserUtil.getUserOpenIdList();
    }

    /**
     * 批量获取用户信息,一次可获取10000条
     */
    public static JSONObject getBatchUserInfo(JSONObject params) {
        return FwUserUtil.getBatchUserInfo(params);
    }

    /**
     * User: jun
     * Date: 2016/11/29
     * Desc: 发送模板消息;
     */
    public static JSONObject sendTemplate(FwTemplateBean fwTemplate) {
        return FwTemplateUtil.sendTemplate(fwTemplate);
    }

    /**
     * User: jun
     * Date: 2017/8/11
     * Desc: 获取 wx.config() 的参数, 需完整的url, 包含参数, 但不包含 # 号后面的数据;
     */
    public static JSONObject getJsSdkConfig(String url) {
        return FwTokenUtil.getJsSdkConfig(url);
    }

    /**
     * User: jun
     * Date: 2018/1/9
     * Desc: 获取微信支付数据
     */
    public static JSONObject getPayParams(FwPrepayBean fwPrepayBean) {
        return FwPayUtil.getPayParams(fwPrepayBean);
    }

    /**
     * User: jun
     * Date: 2018/1/9
     * Desc: 获取微信支付订单号
     */
    public static String getOrderNumber(String preFixString) {
        return FwPayUtil.getOrderNumber(preFixString);
    }

}
