package net.oschina.suyeer.fastwechat.util;

import net.oschina.suyeer.fastwechat.bean.base.WeChatProperties;

/**
 * Created by jun on 2016/11/26.
 */
public class ConstUtil {

    // 微信公众号参数配置
    public static final String APP_ID = WeChatProperties.getInstance().getAppId();
    public static final String APP_SECRET = WeChatProperties.getInstance().getAppSecret();
    public static final String MCH_ID = WeChatProperties.getInstance().getMchId();
    public static final String PARTNER_ID = WeChatProperties.getInstance().getPartnerId();
    public static final String PARTNER_KEY = WeChatProperties.getInstance().getPartnerKey();
    public static final String DOMAIN = WeChatProperties.getInstance().getDomain();
    public static final Boolean IF_LOCALCACHE = WeChatProperties.getInstance().getIfLocalCache();
    public static final Boolean IF_MEMCACHED = WeChatProperties.getInstance().getIfMemCached();
    public static final int TICKET_CACHE_REFRESH_TIME = WeChatProperties.getInstance().getTicketCacheRefreshTime();
    public static final int ACCESS_TOKEN_ACTIVE_TIME = WeChatProperties.getInstance().getAccessTokenActiveTime();

    // common
    public static final String DEFAULT_ENCODE = "UTF-8";
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    public static final String CONTENT_TYPE_APPLICATION_XML = "application/xml";
    public static final String CONTENT_TYPE_APPLICATION_JSONP = "application/x-json";
    public static final String CONTENT_TYPE_URLENCODED = "application/x-www-form-urlencoded";
    public static final String STRING_EMPTY = "";
    public static final String ERROR = "### ERROR IN FASTWECHAT ###";

    // 微信开发数据
    public final static String WX_URL_CGI_BIN_ACCESS_TOKEN = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + APP_ID + "&secret=" + APP_SECRET;
    public final static String WX_URL_GET_JS_API_TICKET = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi&access_token=";
    public final static String WX_URL_GET_USER_INFO = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=%s&openid=%s&lang=%s";
    public final static String WX_KEY_ACCESS_TOKEN = "WX_KEY_ACCESS_TOKEN";
    public final static String WX_KEY_JS_API_TICKET = "WX_KEY_JS_API_TICKET";
    public final static String MC_WX_KEY_ACCESS_TOKEN = "MC_WX_KEY_ACCESS_TOKEN";
    public final static String WX_PARAMETER_ACCESS_TOKEN = "access_token";
    public final static String WX_PARAMETER_TICKET = "ticket";
    public final static String WX_URL_UNIFIED_ORDER = "https://api.mch.weixin.qq.com/pay/unifiedorder";
    public final static String WX_URL_ORDER_QUERY = "https://api.mch.weixin.qq.com/pay/orderquery";

    // 菜单工具
    public final static String WX_URL_CREATE_MENU = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=";

    // 模板消息
    public final static String WX_URL_SEND_TEMPLATE_MESSAGE = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=";

    // 用户相关
    public final static String WX_URL_OAUTH2_ACCESS_TOKEN = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + APP_ID + "&secret=" + APP_SECRET + "&grant_type=authorization_code&code=";
    public final static String WX_URL_OAUTH2_REFRESH_TOKEN = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=" + APP_ID + "&grant_type=refresh_token&refresh_token=";
    public final static String WX_URL_OAUTH2_GET_USER_INFO = "https://api.weixin.qq.com/sns/userinfo?lang=zh_CN&access_token=%s&openid=%s";
    public final static String WX_URL_GET_USER_LIST_OPENID = "https://api.weixin.qq.com/cgi-bin/user/get?access_token=";
    public final static String WX_URL_GET_BATCH_USER_INFO = "https://api.weixin.qq.com/cgi-bin/user/info/batchget?access_token=";


}
