/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.suyeer.fastwechat.util;

import com.alibaba.fastjson.JSONObject;
import java.util.TreeMap;
import net.oschina.suyeer.basic.util.BHttpResUtil;
import net.oschina.suyeer.basic.util.BJsonUtil;
import net.oschina.suyeer.cache.MemCachedUtil;
import net.oschina.suyeer.fastwechat.bean.fwcommon.CacheBean;
import net.oschina.suyeer.fastwechat.bean.fwcommon.JsSdkConfig;
import net.oschina.suyeer.fastwechat.module.WeChatDataCache;
import net.oschina.suyeer.fastwechat.util.ConstUtil;
import net.oschina.suyeer.fastwechat.util.FwBaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FwTokenUtil {
    private static Logger logger = LoggerFactory.getLogger(FwBaseUtil.class);
    private static final int CACHE_TIME = 6000;
    private static final int TWO_HOURS_SECOND = 7200;

    public static String getAccessToken() {
        if (ConstUtil.IF_MEMCACHED.booleanValue()) {
            return FwTokenUtil.getAccessTokenFromMC();
        }
        if (ConstUtil.IF_LOCALCACHE.booleanValue()) {
            return FwTokenUtil.getAccessTokenFromLocal();
        }
        return FwTokenUtil.getAccessTokenFromWx();
    }

    public static String getJsApiTicket() {
        if (ConstUtil.IF_MEMCACHED.booleanValue() || ConstUtil.IF_LOCALCACHE.booleanValue()) {
            return FwTokenUtil.getJsApiTicketFromLocal();
        }
        return FwTokenUtil.getJsApiTicketFromWx();
    }

    private static String getAccessTokenFromWx() {
        try {
            return FwTokenUtil.getFromWx(ConstUtil.WX_URL_CGI_BIN_ACCESS_TOKEN, "access_token");
        }
        catch (Exception e) {
            logger.error("{} \u83b7\u53d6AccessToken\u5931\u8d25, {}", (Object)"### ERROR IN FASTWECHAT ###", (Object)e.getMessage());
            return null;
        }
    }

    private static String getJsApiTicketFromWx() {
        try {
            return FwTokenUtil.getFromWx("https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi&access_token=" + FwTokenUtil.getAccessToken(), "ticket");
        }
        catch (Exception e) {
            logger.error("{} \u83b7\u53d6JsApiTicket\u5931\u8d25, {}", (Object)"### ERROR IN FASTWECHAT ###", (Object)e.getMessage());
            return null;
        }
    }

    private static String getAccessTokenFromLocal() {
        try {
            CacheBean cache = WeChatDataCache.getInstance().get("WX_KEY_ACCESS_TOKEN");
            if (cache != null && cache.isNotExpired().booleanValue()) {
                return cache.getValue();
            }
            String value = FwTokenUtil.getAccessTokenFromWx();
            if (value == null) {
                throw new Exception("\u4e0e\u5fae\u4fe1\u670d\u52a1\u5668\u4ea4\u4e92\u5f02\u5e38!");
            }
            WeChatDataCache.getInstance().add("WX_KEY_ACCESS_TOKEN", value, 6000);
            return value;
        }
        catch (Exception e) {
            logger.error("{} \u83b7\u53d6AccessToken\u5931\u8d25, {}", (Object)"### ERROR IN FASTWECHAT ###", (Object)e.getMessage());
            return null;
        }
    }

    private static String getJsApiTicketFromLocal() {
        try {
            CacheBean cache = WeChatDataCache.getInstance().get("WX_KEY_JS_API_TICKET");
            if (cache != null && cache.isNotExpired().booleanValue()) {
                return cache.getValue();
            }
            String value = FwTokenUtil.getJsApiTicketFromWx();
            if (value == null) {
                throw new Exception("\u4e0e\u5fae\u4fe1\u670d\u52a1\u5668\u4ea4\u4e92\u5f02\u5e38!");
            }
            Long nowSec = FwBaseUtil.getTimestamp();
            int overSec = nowSec.intValue() % 7200;
            int remainderSec = 7200 - overSec;
            if (remainderSec > ConstUtil.TICKET_CACHE_SLEEP && overSec > ConstUtil.TICKET_CACHE_SLEEP) {
                WeChatDataCache.getInstance().add("WX_KEY_JS_API_TICKET", value, remainderSec - ConstUtil.TICKET_CACHE_SLEEP);
            }
            return value;
        }
        catch (Exception e) {
            logger.error("{} \u83b7\u53d6JsApiTicket\u5931\u8d25, {}", (Object)"### ERROR IN FASTWECHAT ###", (Object)e.getMessage());
            return null;
        }
    }

    private static String getAccessTokenFromMC() {
        try {
            CacheBean cache = (CacheBean)MemCachedUtil.get((String)"MC_WX_KEY_ACCESS_TOKEN");
            if (cache != null) {
                return cache.getValue();
            }
            String value = FwTokenUtil.getAccessTokenFromWx();
            if (value == null) {
                throw new Exception("\u4e0e\u5fae\u4fe1\u670d\u52a1\u5668\u4ea4\u4e92\u5f02\u5e38!");
            }
            CacheBean newCache = new CacheBean("MC_WX_KEY_ACCESS_TOKEN", value, 6000L);
            MemCachedUtil.set((String)"MC_WX_KEY_ACCESS_TOKEN", (Object)newCache, (long)6000L);
            return value;
        }
        catch (Exception e) {
            logger.error("{} \u83b7\u53d6AccessToken\u5931\u8d25, {}", (Object)"### ERROR IN FASTWECHAT ###", (Object)e.getMessage());
            return null;
        }
    }

    private static String getFromWx(String url, String key) throws Exception {
        JSONObject obj = BHttpResUtil.sendHttpGetRequest((String)url);
        if (obj == null || !obj.containsKey((Object)key)) {
            throw new Exception(String.format("\u5fae\u4fe1\u8fd4\u56de\u503c\u9519\u8bef: %s, \u8bf7\u6c42URL: %s", BJsonUtil.toString((Object)obj), url));
        }
        return obj.getString(key);
    }

    public static JsSdkConfig getJsSdkConfig(String url) {
        JsSdkConfig jsSdkConfig = new JsSdkConfig();
        try {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("noncestr", jsSdkConfig.getNonceStr());
            treeMap.put("jsapi_ticket", FwTokenUtil.getJsApiTicket());
            treeMap.put("timestamp", jsSdkConfig.getTimestamp());
            treeMap.put("url", url);
            jsSdkConfig.setSignature(FwBaseUtil.createJsSdKSign(treeMap));
        }
        catch (Exception e) {
            logger.error("{} \u83b7\u53d6JsSdk\u7684\u914d\u7f6e\u4fe1\u606fJsSdkConfig\u5931\u8d25\uff1a{}", (Object)"### ERROR IN FASTWECHAT ###", (Object)e.getMessage());
        }
        finally {
            return jsSdkConfig;
        }
    }
}

