package net.oschina.suyeer.fastwechat.util;

import com.alibaba.fastjson.JSONObject;
import net.oschina.suyeer.fastwechat.bean.fwcommon.JsSdkConfig;
import net.oschina.suyeer.fastwechat.bean.fwtemplate.FwTemplateBean;
import net.oschina.suyeer.fastwechat.enums.LanguageEnum;

/**
 * Created by jun on 2016/11/29.
 */
public class FwUtil {

    /**
     * User: jun
     * Date: 2016/11/29
     * Desc: 获取全局AccessToken;
     */
    public static String getAccessToken() {
        return FwTokenUtil.getAccessToken();
    }

    /**
     * User: jun
     * Date: 2016/11/29
     * Desc: 获取JsApiTicket;
     */
    public static String getJsApiTicket() {
        return FwTokenUtil.getJsApiTicket();
    }

    /**
     * User: jun
     * Date: 2016/11/29
     * Desc: 根据openId获取用户信息, 需要用户关注公众号; 默认中文信息;
     */
    public static JSONObject getUserInfoByOpenId(String openId) {
        return getUserInfoByOpenId(openId, LanguageEnum.zh_CN);
    }

    /**
     * User: jun
     * Date: 2016/11/29
     * Desc: 根据openId获取用户信息, 需要用户关注公众号;
     */
    public static JSONObject getUserInfoByOpenId(String openId, LanguageEnum language) {
        String url = String.format(ConstUtil.WX_URL_GET_USER_INFO, getAccessToken(), openId, language.getCode());
        return FwUserUtil.getUserInfo(url);
    }

    /**
     * User: jun
     * Date: 2016/11/29
     * Desc: 发送模板消息;
     */
    public static JSONObject sendTemplate(FwTemplateBean fwTemplate) {
        return FwTemplateUtil.sendTemplate(fwTemplate);
    }

    /**
     * User: jun
     * Date: 2017/8/11
     * Desc: 获取 wx.config() 的参数, 需完整的url, 包含参数, 但不包含 # 号后面的数据;
     */
    public static JsSdkConfig getJsSdkConfig(String url) {
        return FwTokenUtil.getJsSdkConfig(url);
    }

}
