package net.oschina.suyeer.fastwechat.util;

import net.oschina.suyeer.basic.util.BDateUtil;
import net.oschina.suyeer.basic.util.BHttpResUtil;
import net.oschina.suyeer.basic.util.BJsonUtil;
import net.oschina.suyeer.basic.util.BasicUtil;
import net.oschina.suyeer.fastwechat.bean.fwpay.FwPrepayBean;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

import static net.oschina.suyeer.fastwechat.util.ConstUtil.STRING_EMPTY;
import static net.oschina.suyeer.fastwechat.util.ConstUtil.WX_URL_UNIFIED_ORDER;
import static net.oschina.suyeer.fastwechat.util.FwBaseUtil.createSign;

/**
 * Created by jun on 2017/2/9.
 */
public class FwPayUtil {

    private static Logger logger = LoggerFactory.getLogger(FwPayUtil.class);
    private static Date today = new Date();
    private static int orderIndex = 0;

    public static String getPayParams(FwPrepayBean fwPrepayBean) {
        try {
            FwBaseUtil.checkParams(fwPrepayBean);
            String jsParam = null;
            String prepayId = getPrepayId(fwPrepayBean);
            if (prepayId != null && prepayId.length() > 10) {
                jsParam = createPackageValue(prepayId);
            }
            return jsParam;
        } catch (Exception e) {
            logger.error("获取微信支付起调参数失败: {}", e.getMessage());
            return null;
        }
    }

    private static String getPrepayId(FwPrepayBean fwPrepayBean) {
        TreeMap<String, String> treeMap = BJsonUtil.changeType(fwPrepayBean, TreeMap.class);
        StringBuilder xmlStr = new StringBuilder();
        xmlStr.append("<xml>\n");
        for (Map.Entry<String, String> entry : treeMap.entrySet()) {
            xmlStr.append(String.format("<%s>%s</%s>\n", entry.getKey(), entry.getValue(), entry.getKey()));
        }
        xmlStr.append(String.format("<sign>%s</sign>\n</xml>", createSign(treeMap)));
        String result = BHttpResUtil.sendHttpPostRequest(WX_URL_UNIFIED_ORDER, xmlStr.toString());
        result = result.replaceAll("<![CDATA[|]]>", STRING_EMPTY);
        return Jsoup.parse(result).select("prepay_id").html();
    }

    private static String createPackageValue(String prepayId) {
        TreeMap<String, String> treeMap = new TreeMap<>();
        treeMap.put("appId", ConstUtil.APP_ID);
        treeMap.put("timeStamp", BDateUtil.getTimestamp());
        treeMap.put("nonceStr", BasicUtil.getNonceStr());
        treeMap.put("package", "prepay_id=" + prepayId);
        treeMap.put("signType", "MD5");
        treeMap.put("paySign", FwBaseUtil.createSign(treeMap));
        /*为支持 wx.chooseWXPay, 这里新写入一个timestamp参数*/
        treeMap.put("timestamp", treeMap.get("timeStamp"));
        return BJsonUtil.toString(treeMap);
    }

    public static String getOrderNumber(String preFixString) {
        Date currTime = new Date();
        String currTimeStr = BDateUtil.getShortTimeFormStr(currTime);
        if (orderIndex > 0 && orderIndex < 900000 && BDateUtil.isSameDay(currTime, today)) {
            orderIndex++;
        } else {
            today = currTime;
            orderIndex = 1;
        }
        return String.format("%s%s%06d", preFixString, currTimeStr, orderIndex);
    }

}
