package net.oschina.suyeer.fastwechat.bean.base;

/**
 * Created by jun on 2016/11/26.
 */
public class WeChatProperties {

    private static class LazyHolder {
        private static final WeChatProperties ourInstance = new WeChatProperties();
    }

    public static WeChatProperties getInstance() {
        return LazyHolder.ourInstance;
    }

    /**
     * Request: YES;
     * Desc: 微信公众号 appId;
     */
    private static String appId;

    /**
     * Request: YES;
     * Desc: 微信公众号 appSecret;
     */
    private static String appSecret;

    /**
     * Request: NO;
     * Desc: 微信商户开发 mchId, 接入支付时使用;
     */
    private static String mchId;

    /**
     * Request: NO;
     * Desc: 微信商户开发 partnerId, 接入支付时使用;
     */
    private static String partnerId;

    /**
     * Request: NO;
     * Desc: 微信商户开发 partnerKey, 接入支付时使用;
     */
    private static String partnerKey;

    /**
     * Request: NO;
     * Desc: 在微信公众号设置的域名, 需指定http 或 https;
     * Example: https://www.suyeer.com
     */
    private static String domain;

    /**
     * Request: NO;
     * Desc: 是否启用本地缓存来存储微信的全局access token数据, 默认启用;
     * <p>
     * 当 (ifLocalCache || ifMemCached) == true 时, JsApiTicket会在本地缓存存储;
     * <p>
     * 缓存优先级为: memcached > localCache > 不需要缓存;
     */
    private static Boolean ifLocalCache = true;

    /**
     * Request: NO, 若项目非 负载均衡 项目;
     * Request: YES, 若项目是 负载均衡 项目;
     * Desc: 是否启用MemCached缓存来存储微信的全局access token数据, 默认不启用, 如设为true,
     * 则需配置memcached参数;
     * <p>
     * memcached参数配置请参考: http://git.oschina.net/suyeer/cache/wikis/config
     * <p>
     * JsApiTicket 无需同步到memcached;
     * 当 (ifLocalCache || ifMemCached) == true 时, JsApiTicket会在本地缓存存储;
     * <p>
     * 缓存优先级为: memcached > localCache > 不需要缓存;
     */
    private static Boolean ifMemCached = false;

    /**
     * Request: NO;
     * Desc: JsApiTicket 在微信生成的规则是, 从 00:00 开始, 每隔 2 小时更新一次.
     * 本地也会在这个时间点请求微信获取数据, 但由于本地时间和微信服务器时间存在误差,
     * 可能存在: 本地时间 02:01 请求微信数据并缓存, 但微信服务器时间为 01:59, 此
     * 时缓存的数据就会有误.
     * 本参数是为解决这个问题. 设值为 360 表示, 本地时间 01:57 ~ 02:03 这 360 秒
     * 内, 所有 JsApiTicket 的请求直接从微信服务器获取, 且不保存到缓存.
     * 02:03:01 ~ 03:56:59 的请求直接从缓存获取, 若无缓存, 则从微信获取并缓存.
     * <p>
     * 参数取值范围: 0 ~ 1000
     */
    private static Integer ticketCacheSleep = 360;

    private WeChatProperties() {
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getPartnerId() {
        return partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getPartnerKey() {
        return partnerKey;
    }

    public void setPartnerKey(String partnerKey) {
        this.partnerKey = partnerKey;
    }

    public Boolean getIfLocalCache() {
        return ifLocalCache;
    }

    public void setIfLocalCache(Boolean ifLocalCache) {
        this.ifLocalCache = ifLocalCache;
    }

    public Boolean getIfMemCached() {
        return ifMemCached;
    }

    public void setIfMemCached(Boolean ifMemCached) {
        this.ifMemCached = ifMemCached;
    }

    public String getDomain() {
        if (domain != null && domain.endsWith("/")) {
            domain = domain.substring(0, domain.length() - 1);
        }
        return domain;
    }

    public void setDomain(String domain) {
        WeChatProperties.domain = domain;
    }

    public static Integer getTicketCacheSleep() {
        ticketCacheSleep = Math.max(ticketCacheSleep.intValue(), 0);
        ticketCacheSleep = Math.min(ticketCacheSleep.intValue(), 1000);
        return ticketCacheSleep / 2;
    }

    public static void setTicketCacheSleep(Integer ticketCacheSleep) {
        WeChatProperties.ticketCacheSleep = ticketCacheSleep;
    }
}
