/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.suyeer.fastwechat.util;

import com.alibaba.fastjson.JSONObject;
import java.util.TreeMap;
import net.oschina.suyeer.basic.util.BHttpResUtil;
import net.oschina.suyeer.basic.util.BJsonUtil;
import net.oschina.suyeer.cache.MemCachedUtil;
import net.oschina.suyeer.fastwechat.bean.base.CacheBean;
import net.oschina.suyeer.fastwechat.bean.base.JsSdkConfig;
import net.oschina.suyeer.fastwechat.bean.base.TicketBean;
import net.oschina.suyeer.fastwechat.module.WeChatDataCache;
import net.oschina.suyeer.fastwechat.util.ConstUtil;
import net.oschina.suyeer.fastwechat.util.FwBaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FwTokenUtil {
    private static Logger logger = LoggerFactory.getLogger(FwBaseUtil.class);
    private static TicketBean jsApiTicket = new TicketBean(ConstUtil.IF_MEMCACHED);

    public static String getAccessToken() {
        if (ConstUtil.IF_MEMCACHED.booleanValue()) {
            return FwTokenUtil.getAccessTokenFromMC();
        }
        if (ConstUtil.IF_LOCALCACHE.booleanValue()) {
            return FwTokenUtil.getAccessTokenFromLocal();
        }
        return FwTokenUtil.getAccessTokenFromWx();
    }

    public static String getJsApiTicket() {
        if (ConstUtil.IF_MEMCACHED.booleanValue()) {
            return FwTokenUtil.getJsApiTicketFromMC();
        }
        if (ConstUtil.IF_LOCALCACHE.booleanValue()) {
            return FwTokenUtil.getJsApiTicketFromLocal();
        }
        return FwTokenUtil.getJsApiTicketFromWx();
    }

    private static String getAccessTokenFromWx() {
        try {
            return FwTokenUtil.getFromWx(ConstUtil.WX_URL_CGI_BIN_ACCESS_TOKEN, "access_token");
        }
        catch (Exception e) {
            logger.error("{} \u83b7\u53d6AccessToken\u5931\u8d25, {}", (Object)e.getMessage());
            return null;
        }
    }

    private static String getJsApiTicketFromWx() {
        try {
            return FwTokenUtil.getFromWx("https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi&access_token=" + FwTokenUtil.getAccessToken(), "ticket");
        }
        catch (Exception e) {
            logger.error("{} \u83b7\u53d6JsApiTicket\u5931\u8d25, {}", (Object)"### ERROR IN FASTWECHAT ###", (Object)e.getMessage());
            return null;
        }
    }

    private static String getAccessTokenFromLocal() {
        try {
            CacheBean cache = WeChatDataCache.getInstance().get("WX_KEY_ACCESS_TOKEN");
            if (cache != null && cache.isNotExpired().booleanValue()) {
                return cache.getValue();
            }
            String value = FwTokenUtil.getAccessTokenFromWx();
            if (value == null) {
                throw new Exception("\u4e0e\u5fae\u4fe1\u4ea4\u4e92\u5f02\u5e38!");
            }
            WeChatDataCache.getInstance().add("WX_KEY_ACCESS_TOKEN", value, 7000);
            return value;
        }
        catch (Exception e) {
            logger.error("{} \u83b7\u53d6AccessToken\u5931\u8d25, {}", (Object)"### ERROR IN FASTWECHAT ###", (Object)e.getMessage());
            return null;
        }
    }

    private static String getJsApiTicketFromLocal() {
        try {
            String value = FwTokenUtil.getValue();
            if (jsApiTicket.isFirstValue().booleanValue()) {
                return value;
            }
            CacheBean cache = WeChatDataCache.getInstance().get("WX_KEY_JS_API_TICKET");
            if (cache != null && cache.isNotExpired().booleanValue()) {
                return cache.getValue();
            }
            if (value == null) {
                value = FwTokenUtil.getJsApiTicketFromWx();
            }
            if (value == null) {
                throw new Exception("\u4e0e\u5fae\u4fe1\u4ea4\u4e92\u5f02\u5e38!");
            }
            if (cache != null && value.equals(cache.getValue())) {
                return value;
            }
            WeChatDataCache.getInstance().add("WX_KEY_JS_API_TICKET", value, 7180);
            return value;
        }
        catch (Exception e) {
            logger.error("{} \u83b7\u53d6JsApiTicket\u5931\u8d25, {}", (Object)"### ERROR IN FASTWECHAT ###", (Object)e.getMessage());
            return null;
        }
    }

    private static String getAccessTokenFromMC() {
        try {
            CacheBean cache = (CacheBean)MemCachedUtil.get((String)"MC_WX_KEY_ACCESS_TOKEN");
            if (cache != null) {
                return cache.getValue();
            }
            String value = FwTokenUtil.getAccessTokenFromWx();
            if (value == null) {
                throw new Exception("\u4e0e\u5fae\u4fe1\u4ea4\u4e92\u5f02\u5e38!");
            }
            CacheBean newBean = new CacheBean("MC_WX_KEY_ACCESS_TOKEN", value);
            MemCachedUtil.set((String)"MC_WX_KEY_ACCESS_TOKEN", (Object)newBean, (long)7000L);
            return value;
        }
        catch (Exception e) {
            logger.error("{} \u83b7\u53d6AccessToken\u5931\u8d25, {}", (Object)"### ERROR IN FASTWECHAT ###", (Object)e.getMessage());
            return null;
        }
    }

    private static String getJsApiTicketFromMC() {
        try {
            String value = FwTokenUtil.getValue();
            if (jsApiTicket.isFirstValue().booleanValue()) {
                return value;
            }
            CacheBean cache = (CacheBean)MemCachedUtil.get((String)"MC_WX_KEY_JS_API_TICKET");
            if (cache != null && cache.isNotExpired().booleanValue()) {
                return cache.getValue();
            }
            if (value == null) {
                value = FwTokenUtil.getJsApiTicketFromWx();
            }
            if (value == null) {
                throw new Exception("\u4e0e\u5fae\u4fe1\u4ea4\u4e92\u5f02\u5e38!");
            }
            if (cache != null && value.equals(cache.getValue())) {
                return value;
            }
            if (cache == null) {
                jsApiTicket = new TicketBean();
                return value;
            }
            CacheBean newBean = new CacheBean("MC_WX_KEY_ACCESS_TOKEN", value, 7000L);
            MemCachedUtil.set((String)"MC_WX_KEY_JS_API_TICKET", (Object)newBean, (long)864000L);
            return value;
        }
        catch (Exception e) {
            logger.error("{} \u83b7\u53d6JsApiTicket\u5931\u8d25, {}", (Object)"### ERROR IN FASTWECHAT ###", (Object)e.getMessage());
            return null;
        }
    }

    private static String getFromWx(String url, String key) throws Exception {
        JSONObject obj = BHttpResUtil.sendHttpGetRequest((String)url);
        if (obj == null || !obj.containsKey((Object)key)) {
            throw new Exception(String.format("\u5fae\u4fe1\u8fd4\u56de\u503c\u9519\u8bef: %s, \u8bf7\u6c42URL: %s", BJsonUtil.toString((Object)obj), url));
        }
        return obj.getString(key);
    }

    public static JsSdkConfig getJsSdkConfig(String url) {
        JsSdkConfig jsSdkConfig = new JsSdkConfig();
        try {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("noncestr", jsSdkConfig.getNonceStr());
            treeMap.put("jsapi_ticket", FwTokenUtil.getJsApiTicket());
            treeMap.put("timestamp", jsSdkConfig.getTimestamp());
            treeMap.put("url", url);
            jsSdkConfig.setSignature(FwBaseUtil.createJsSdKSign(treeMap));
        }
        catch (Exception e) {
            logger.error("{} \u83b7\u53d6JsSdk\u7684\u914d\u7f6e\u4fe1\u606fJsSdkConfig\u5931\u8d25\uff1a{}", (Object)"### ERROR IN FASTWECHAT ###", (Object)e.getMessage());
        }
        finally {
            return jsSdkConfig;
        }
    }

    private static String getValue() throws Exception {
        String value = null;
        if (jsApiTicket.isFirstValue().booleanValue()) {
            value = FwTokenUtil.getJsApiTicketFromWx();
            if (value == null) {
                throw new Exception("\u4e0e\u5fae\u4fe1\u4ea4\u4e92\u5f02\u5e38!");
            }
            if (jsApiTicket.getValue() == null) {
                jsApiTicket.setValue(value);
            }
            jsApiTicket.setIsFirstValue(value.equals(jsApiTicket.getValue()));
            if (jsApiTicket.isFirstValue().booleanValue()) {
                jsApiTicket.setIsFirstValue(jsApiTicket.isTwoHours());
            }
        }
        return value;
    }
}

