package net.oschina.suyeer.fastwechat.bean.base;

/**
 * Created by jun on 2016/11/26.
 */
public class WeChatProperties {

    private static class LazyHolder {
        private static final WeChatProperties ourInstance = new WeChatProperties();
    }

    public static WeChatProperties getInstance() {
        return LazyHolder.ourInstance;
    }

    /**
     * Request: YES;
     * Desc: 微信公众号 appId;
     */
    private static String appId;

    /**
     * Request: YES;
     * Desc: 微信公众号 appSecret;
     */
    private static String appSecret;

    /**
     * Request: NO;
     * Desc: 微信商户开发 mchId, 接入支付时使用;
     */
    private static String mchId;

    /**
     * Request: NO;
     * Desc: 微信商户开发 partnerId, 接入支付时使用;
     */
    private static String partnerId;

    /**
     * Request: NO;
     * Desc: 微信商户开发 partnerKey, 接入支付时使用;
     */
    private static String partnerKey;

    /**
     * Request: NO;
     * Desc: 在微信公众号设置的域名, 需指定http 或 https;
     * Example: https://www.suyeer.com
     */
    private static String domain;

    /**
     * Request: NO;
     * Desc: 是否启用本地缓存来存储微信的Token数据, 默认启用;
     * 缓存优先级为: memcached > localCache > 不需要缓存;
     */
    private static Boolean ifLocalCache = true;

    /**
     * Request: NO, 若项目非 负载均衡 项目;
     * Request: YES, 若项目是 负载均衡 项目, 且服务器集群必须同步系统时间;
     * Desc: 是否启用MemCached缓存来存储微信的Token数据, 默认不启用, 如设为true, 则需配置memcached参数;
     * memcached参数配置请参考: http://git.oschina.net/suyeer/cache/wikis/config
     * 缓存优先级为: memcached > localCache > 不需要缓存;
     */
    private static Boolean ifMemCached = false;

    private WeChatProperties() {
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getPartnerId() {
        return partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getPartnerKey() {
        return partnerKey;
    }

    public void setPartnerKey(String partnerKey) {
        this.partnerKey = partnerKey;
    }

    public Boolean getIfLocalCache() {
        return ifLocalCache;
    }

    public void setIfLocalCache(Boolean ifLocalCache) {
        this.ifLocalCache = ifLocalCache;
    }

    public Boolean getIfMemCached() {
        return ifMemCached;
    }

    public void setIfMemCached(Boolean ifMemCached) {
        this.ifMemCached = ifMemCached;
    }

    public String getDomain() {
        if (domain != null && domain.endsWith("/")) {
            domain = domain.substring(0, domain.length() - 1);
        }
        return domain;
    }

    public void setDomain(String domain) {
        WeChatProperties.domain = domain;
    }

}
