/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.suyeer.fastwechat.module;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.oschina.suyeer.basic.util.BDateUtil;
import net.oschina.suyeer.basic.util.BHttpResUtil;
import net.oschina.suyeer.fastwechat.bean.base.CacheBean;
import net.oschina.suyeer.fastwechat.bean.base.JsSdkConfig;
import net.oschina.suyeer.fastwechat.util.ConstUtil;
import net.oschina.suyeer.fastwechat.util.FwBaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeChatDataCache {
    private static Logger logger = LoggerFactory.getLogger(WeChatDataCache.class);
    private final ConcurrentMap<String, CacheBean> weChatCacheMap = new ConcurrentHashMap<String, CacheBean>();

    public static WeChatDataCache getInstance() {
        return LazyHolder.INSTANCE;
    }

    private WeChatDataCache() {
    }

    private void put(String key, String value) {
        CacheBean cacheBean = new CacheBean();
        cacheBean.setValue(value);
        cacheBean.setCreateTime(new Date());
        this.weChatCacheMap.put(key, cacheBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String get(String key) {
        String ret = null;
        try {
            if (this.weChatCacheMap.containsKey(key)) {
                CacheBean cacheBean = (CacheBean)this.weChatCacheMap.get(key);
                if (!BDateUtil.checkExpired((Date)cacheBean.getCreateTime(), (int)ConstUtil.WX_CACHE_KEEP_EXPIRED_SECOND).booleanValue()) {
                    ret = cacheBean.getValue();
                    return ret;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25: {}", (Object)e.getMessage());
        }
        finally {
            return ret;
        }
    }

    public String getAccessToken() {
        String ret = null;
        try {
            block7: {
                if (ConstUtil.IF_LOCALCACHE.booleanValue()) {
                    ret = this.get("WX_KEY_ACCESS_TOKEN");
                }
                if (ret != null) break block7;
                JSONObject obj = BHttpResUtil.sendHttpGetRequest((String)ConstUtil.WX_URL_CGI_BIN_ACCESS_TOKEN);
                if (obj == null) break;
                if (obj.containsKey((Object)"access_token")) {
                    ret = obj.getString("access_token");
                    this.put("WX_KEY_ACCESS_TOKEN", ret);
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6AccessToken\u5931\u8d25: {}", (Object)e.getMessage());
        }
        finally {
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJsApiTicket() {
        String ret = null;
        try {
            block7: {
                if (ConstUtil.IF_LOCALCACHE.booleanValue()) {
                    ret = this.get("WX_KEY_JS_API_TICKET");
                }
                if (ret != null) break block7;
                String accessToken = this.getAccessToken();
                if (accessToken == null) break;
                JSONObject obj = BHttpResUtil.sendHttpGetRequest((String)("https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi&access_token=" + accessToken));
                if (obj == null) break;
                if (obj.containsKey((Object)"ticket")) {
                    ret = obj.getString("ticket");
                    this.put("WX_KEY_JS_API_TICKET", ret);
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6JsApiTicket\u5931\u8d25: {}", (Object)e.getMessage());
        }
        finally {
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsSdkConfig getJsSdkConfig(String url) {
        JsSdkConfig jsSdkConfig = new JsSdkConfig();
        try {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("noncestr", jsSdkConfig.getNonceStr());
            treeMap.put("jsapi_ticket", this.getJsApiTicket());
            treeMap.put("timestamp", jsSdkConfig.getTimestamp());
            treeMap.put("url", url);
            jsSdkConfig.setSignature(FwBaseUtil.createJsSdKSign(treeMap));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6JsSdk\u7684\u914d\u7f6e\u4fe1\u606fJsSdkConfig\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        finally {
            return jsSdkConfig;
        }
    }

    private static class LazyHolder {
        private static final WeChatDataCache INSTANCE = new WeChatDataCache();

        private LazyHolder() {
        }
    }
}

