package net.oschina.suyeer.fastwechat.bean.base;

/**
 * Created by jun on 2016/11/26.
 */
public class WeChatProperties {

    private static class LazyHolder {
        private static final WeChatProperties ourInstance = new WeChatProperties();
    }

    public static WeChatProperties getInstance() {
        return LazyHolder.ourInstance;
    }

    private static String appId;
    private static String appSecret;
    private static String mchId;
    private static String partnerId;
    private static String partnerKey;
    private static String domain;
    private static Boolean ifLocalCache = false;
    private static Boolean ifMemCached = false;
    private static Boolean ifRedis = false;

    private WeChatProperties() {
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getPartnerId() {
        return partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getPartnerKey() {
        return partnerKey;
    }

    public void setPartnerKey(String partnerKey) {
        this.partnerKey = partnerKey;
    }

    public Boolean getIfLocalCache() {
        return ifLocalCache;
    }

    public void setIfLocalCache(Boolean ifLocalCache) {
        this.ifLocalCache = ifLocalCache;
    }

    public Boolean getIfMemCached() {
        return ifMemCached;
    }

    public void setIfMemCached(Boolean ifMemCached) {
        this.ifMemCached = ifMemCached;
    }

    public Boolean getIfRedis() {
        return ifRedis;
    }

    public void setIfRedis(Boolean ifRedis) {
        this.ifRedis = ifRedis;
    }

    public String getDomain() {
        if (domain != null && domain.endsWith("/")) {
            domain = domain.substring(0, domain.length() - 1);
        }
        return domain;
    }

    public void setDomain(String domain) {
        WeChatProperties.domain = domain;
    }
}
