package net.oschina.suyeer.fastwechat.util;

import com.alibaba.fastjson.JSONObject;
import net.oschina.suyeer.basic.util.BHttpResUtil;
import net.oschina.suyeer.basic.util.BJsonUtil;
import net.oschina.suyeer.fastwechat.bean.fwtemplate.FwTemplateBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static net.oschina.suyeer.fastwechat.util.ConstUtil.WX_URL_SEND_TEMPLATE_MESSAGE;

/**
 * 模板消息方法
 * Created by jun on 2017/2/6.
 */
public class FwTemplateUtil {
    private static Logger logger = LoggerFactory.getLogger(FwMenuUtil.class);

    /**
     * 发送模板消息
     */
    public static JSONObject sendTemplate(FwTemplateBean fwTemplateBean) {
        JSONObject retObj = new JSONObject();
        try {
            retObj = BHttpResUtil.sendSSLPostRequest(WX_URL_SEND_TEMPLATE_MESSAGE + FwUtil.getAccessToken(), BJsonUtil.toString(fwTemplateBean));
        } catch (Exception e) {
            logger.error("发送请求异常: {}", e.getMessage());
        }
        return retObj;
    }
}
