package net.oschina.suyeer.fastwechat.util;

import net.oschina.suyeer.basic.util.BEncryptUtil;
import net.oschina.suyeer.basic.util.BJsonUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/**
 * Created by jun on 2017/2/15.
 */
public class FwBaseUtil {

    private static Logger logger = LoggerFactory.getLogger(FwBaseUtil.class);

    /**
     * User: jun
     * Date: 2017/8/11
     * Desc: 创建md5摘要,规则是:按参数名称a-z排序,遇到空值的参数不参加签名.
     */
    public static String createSign(TreeMap<String, String> treeMap) {
        return BEncryptUtil.MD5(toString(treeMap) + "&key=" + ConstUtil.PARTNER_KEY).toUpperCase();
    }

    public static String createJsSdKSign(TreeMap<String, String> treeMap) {
        return BEncryptUtil.SHA1(toString(treeMap));
    }

    private static String toString(TreeMap<String, String> treeMap) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : treeMap.entrySet()) {
            if (StringUtils.isNotBlank(entry.getKey()) && StringUtils.isNotBlank(entry.getValue())) {
                sb.append(String.format("%s=%s&", entry.getKey(), entry.getValue()));
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    /**
     * User: jun
     * Date: 2017/8/11
     * Desc: 参数校验, 对象类型数据, 不能是基本类型数据.
     */
    public static void checkParams(Object obj) throws Exception {
        Boolean flag = false;
        StringBuilder sb = new StringBuilder();
        sb.append("参数校验 :\n");
        HashMap<String, String> params = BJsonUtil.changeType(obj, HashMap.class);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (StringUtils.isEmpty(entry.getValue())) {
                flag = true;
                sb.append(String.format("\t不合法参数: %s\n", entry.getKey()));
            }
        }
        if (flag) {
            throw new Exception(sb.toString());
        }
    }

    public static long getTimestamp() {
        return System.currentTimeMillis() / 1000;
    }
}
