package net.oschina.suyeer.fastwechat.module;

import com.alibaba.fastjson.JSONObject;
import net.oschina.suyeer.basic.util.BDateUtil;
import net.oschina.suyeer.basic.util.BHttpResUtil;
import net.oschina.suyeer.fastwechat.bean.base.CacheBean;
import net.oschina.suyeer.fastwechat.bean.base.JsSdkConfig;
import net.oschina.suyeer.fastwechat.util.ConstUtil;
import net.oschina.suyeer.fastwechat.util.FwBaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * Created by jun on 2016/11/29.
 */
public class WeChatDataCache {
    private static class LazyHolder {
        private static final WeChatDataCache INSTANCE = new WeChatDataCache();
    }

    public static WeChatDataCache getInstance() {
        return WeChatDataCache.LazyHolder.INSTANCE;
    }

    private WeChatDataCache() {
    }

    private static Logger logger = LoggerFactory.getLogger(WeChatDataCache.class);

    /**
     * 微信缓存, 如 accessToken
     */
    private final ConcurrentMap<String, CacheBean> weChatCacheMap = new ConcurrentHashMap<>();

    private void put(String key, String value) {
        CacheBean cacheBean = new CacheBean();
        cacheBean.setValue(value);
        cacheBean.setCreateTime(new Date());
        weChatCacheMap.put(key, cacheBean);
    }

    private String get(String key) {
        String ret = null;
        try {
            if (weChatCacheMap.containsKey(key)) {
                CacheBean cacheBean = weChatCacheMap.get(key);
                if (!BDateUtil.checkExpired(cacheBean.getCreateTime(), ConstUtil.WX_CACHE_KEEP_EXPIRED_SECOND)) {
                    ret = cacheBean.getValue();
                }
            }
        } catch (Exception e) {
            logger.error("获取数据失败: {}", e.getMessage());
        } finally {
            return ret;
        }
    }

    public String getAccessToken() {
        String ret = null;
        try {
            if (ConstUtil.IF_LOCALCACHE) {
                ret = get(ConstUtil.WX_KEY_ACCESS_TOKEN);
            }
            if (ret == null) {
                JSONObject obj = BHttpResUtil.sendHttpGetRequest(ConstUtil.WX_URL_CGI_BIN_ACCESS_TOKEN);
                if (obj != null && obj.containsKey(ConstUtil.WX_PARAMETER_ACCESS_TOKEN)) {
                    ret = obj.getString(ConstUtil.WX_PARAMETER_ACCESS_TOKEN);
                    put(ConstUtil.WX_KEY_ACCESS_TOKEN, ret);
                }
            }
        } catch (Exception e) {
            logger.error("获取AccessToken失败: {}", e.getMessage());
        } finally {
            return ret;
        }
    }

    public String getJsApiTicket() {
        String ret = null;
        try {
            if (ConstUtil.IF_LOCALCACHE) {
                ret = get(ConstUtil.WX_KEY_JS_API_TICKET);
            }
            if (ret == null) {
                String accessToken = getAccessToken();
                if (accessToken != null) {
                    JSONObject obj = BHttpResUtil.sendHttpGetRequest(ConstUtil.WX_URL_GET_JS_API_TICKET + accessToken);
                    if (obj != null && obj.containsKey(ConstUtil.WX_PARAMETER_TICKET)) {
                        ret = obj.getString(ConstUtil.WX_PARAMETER_TICKET);
                        put(ConstUtil.WX_KEY_JS_API_TICKET, ret);
                    }
                }
            }
        } catch (Exception e) {
            logger.error("获取JsApiTicket失败: {}", e.getMessage());
        } finally {
            return ret;
        }
    }

    /**
     * User: jun
     * Date: 2017/8/10
     * Desc: 获取JsSdkConfig, 用于微信分享配置
     */
    public JsSdkConfig getJsSdkConfig(String url) {
        JsSdkConfig jsSdkConfig = new JsSdkConfig();
        try {
            TreeMap<String, String> treeMap = new TreeMap<>();
            treeMap.put("noncestr", jsSdkConfig.getNonceStr());
            treeMap.put("jsapi_ticket", getJsApiTicket());
            treeMap.put("timestamp", jsSdkConfig.getTimestamp());
            treeMap.put("url", url);
            jsSdkConfig.setSignature(FwBaseUtil.createJsSdKSign(treeMap));
        } catch (Exception e) {
            logger.error("获取JsSdk的配置信息JsSdkConfig失败：{}", e.getMessage());
        } finally {
            return jsSdkConfig;
        }
    }

}

