package net.oschina.suyeer.fastwechat.util;

import com.alibaba.fastjson.JSONObject;
import net.oschina.suyeer.basic.util.BHttpResUtil;
import net.oschina.suyeer.basic.util.BJsonUtil;
import net.oschina.suyeer.fastwechat.bean.fwtemplate.FwTemplateBean;
import org.apache.log4j.Logger;

import static net.oschina.suyeer.fastwechat.util.ConstUtil.WX_URL_SEND_TEMPLATE_MESSAGE;

/**
 * 模板消息方法
 * Created by jun on 2017/2/6.
 */
public class FwTemplateUtil {
    private static Logger logger = Logger.getLogger(FwMenuUtil.class);

    /**
     * 发送模板消息
     */
    public static JSONObject sendTemplate(FwTemplateBean fwTemplateBean) {
        JSONObject retObj = new JSONObject();
        try {
            retObj = BHttpResUtil.sendSSLPostRequest(WX_URL_SEND_TEMPLATE_MESSAGE + FwUtil.getAccessToken(), BJsonUtil.toJsonString(fwTemplateBean));
        } catch (Exception e) {
            logger.error("发送请求异常!", e);
        }
        return retObj;
    }
}
