/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.suyeer.fastwechat.util;

import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import net.oschina.suyeer.basic.util.BDateUtil;
import net.oschina.suyeer.basic.util.BHttpResUtil;
import net.oschina.suyeer.basic.util.BJsonUtil;
import net.oschina.suyeer.basic.util.BasicUtil;
import net.oschina.suyeer.fastwechat.bean.fwpay.FwPrepayBean;
import net.oschina.suyeer.fastwechat.util.ConstUtil;
import net.oschina.suyeer.fastwechat.util.FwBaseUtil;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;

public class FwPayUtil {
    private static Logger logger = Logger.getLogger(FwPayUtil.class);
    private static Date today = new Date();
    private static int orderIndex = 0;

    public static String getPayParams(FwPrepayBean fwPrepayBean) {
        FwBaseUtil.checkParams(fwPrepayBean);
        String jsParam = null;
        String prepayId = FwPayUtil.getPrepayId(fwPrepayBean);
        if (prepayId != null && prepayId.length() > 10) {
            jsParam = FwPayUtil.createPackageValue(prepayId);
        }
        return jsParam;
    }

    private static String getPrepayId(FwPrepayBean fwPrepayBean) {
        TreeMap treeMap = (TreeMap)BJsonUtil.changeType((Object)fwPrepayBean, TreeMap.class);
        StringBuilder xmlStr = new StringBuilder();
        xmlStr.append("<xml>\n");
        for (Map.Entry entry : treeMap.entrySet()) {
            xmlStr.append(String.format("<%s>%s</%s>\n", entry.getKey(), entry.getValue(), entry.getKey()));
        }
        xmlStr.append(String.format("<sign>%s</sign>\n</xml>", FwBaseUtil.createSign(treeMap)));
        String result = BHttpResUtil.sendHttpPostRequest((String)"https://api.mch.weixin.qq.com/pay/unifiedorder", (String)xmlStr.toString());
        result = result.replaceAll("<![CDATA[|]]>", "");
        return Jsoup.parse((String)result).select("prepay_id").html();
    }

    private static String createPackageValue(String prepay_id) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("appId", ConstUtil.APP_ID);
        treeMap.put("timeStamp", BDateUtil.getTimestamp());
        treeMap.put("nonceStr", BasicUtil.getNonceStr());
        treeMap.put("package", "prepay_id=" + prepay_id);
        treeMap.put("signType", "MD5");
        treeMap.put("paySign", FwBaseUtil.createSign(treeMap));
        return BJsonUtil.toJsonString(treeMap);
    }

    public static String getOrderNumber(String preFixString) {
        Date currTime = new Date();
        String currTimeStr = BDateUtil.getShortTimeFormStr((Date)currTime);
        if (orderIndex > 0 && orderIndex < 999999 && BDateUtil.isSameDay((Date)currTime, (Date)today).booleanValue()) {
            ++orderIndex;
        } else {
            today = currTime;
            orderIndex = 1;
        }
        String indexString = String.format("%s%06d", currTimeStr, orderIndex);
        return preFixString + indexString;
    }
}

