package net.oschina.suyeer.fastwechat.util;

import com.alibaba.fastjson.JSONObject;
import net.oschina.suyeer.basic.util.BHttpResUtil;
import org.apache.log4j.Logger;

import static net.oschina.suyeer.fastwechat.util.ConstUtil.*;

/**
 * Created by jun on 2017/2/15.
 */
public class FwUserUtil {

    private static Logger logger = Logger.getLogger(FwUserUtil.class);

    /**
     * 用户授权相关, 根据code换取信息
     */
    public static JSONObject getAuthAccessToken(String code) {
        String url = WX_URL_OAUTH2_ACCESS_TOKEN + code;
        return sendRequest(url);
    }

    /**
     * 用户授权相关, 刷新Token
     */
    public static JSONObject getRefreshToken(String refreshToken) {
        String refreshTokenUrl = WX_URL_OAUTH2_REFRESH_TOKEN + refreshToken;
        return sendRequest(refreshTokenUrl);
    }

    /**
     * 用全局accessToken获取用户信息
     */
    public static JSONObject getUserInfo(String url) {
        return sendRequest(url);
    }

    /**
     * 批量获取用户openid,一次可获取10000条
     */
    public static JSONObject getUserOpenIdList() {
        String url = WX_URL_GET_USER_LIST_OPENID + FwUtil.getAccessToken();
        return sendRequest(url);
    }

    /**
     * 批量获取用户信息,一次可获取10000条
     */
    public static JSONObject getBatchUserInfo() {
        String url = WX_URL_GET_BATCH_USER_INFO + FwUtil.getAccessToken();
        return sendRequest(url);
    }

    /**
     * 发送请求
     */
    private static JSONObject sendRequest(String url) {
        JSONObject retObj = null;
        try {
            retObj = BHttpResUtil.sendHttpGetRequest(url);
        } catch (Exception e) {
            logger.error("请求微信接口失败!", e);
        } finally {
            return retObj;
        }
    }
}
