package net.oschina.suyeer.fastwechat.util;

import net.oschina.suyeer.basic.util.BEncryptUtil;
import net.oschina.suyeer.basic.util.BJsonUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/**
 * Created by jun on 2017/2/15.
 */
public class FwBaseUtil {

    private static Logger logger = Logger.getLogger(FwBaseUtil.class);

    /**
     * 创建md5摘要,规则是:按参数名称a-z排序,遇到空值的参数不参加签名。
     *
     * @param treeMap TreeMap对象
     * @return 返回摘要
     */
    public static String createSign(TreeMap<String, String> treeMap) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : treeMap.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue() + "&");
        }
        sb.append("key=" + ConstUtil.PARTNER_KEY);
        return BEncryptUtil.MD5(sb.toString()).toUpperCase();
    }

    /**
     * 参数校验
     *
     * @param obj 对象类型数据, 不能是基本类型数据
     */
    public static void checkParams(Object obj) {
        Boolean flag = false;
        StringBuilder stb = new StringBuilder();
        stb.append("参数校验 :\n");
        HashMap<String, String> params = BJsonUtil.changeType(obj, HashMap.class);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (StringUtils.isEmpty(entry.getValue())) {
                flag = true;
                stb.append(String.format("\t不合法参数: %s\n", entry.getKey()));
            }
        }
        if (flag) {
            logger.error(stb.toString());
        }
    }
}
