package net.oschina.suyeer.fastwechat.bean.base;

import org.springframework.beans.factory.InitializingBean;

/**
 * Created by jun on 2016/11/26.
 */
public class WeChatProperties implements InitializingBean {

    private static class LazyHolder {
        private static final WeChatProperties ourInstance = new WeChatProperties();
    }

    public static WeChatProperties getInstance() {
        return LazyHolder.ourInstance;
    }

    private static String appId;
    private static String appSecret;
    private static String mchId;
    private static String partnerId;
    private static String partnerKey;
    private static Boolean ifLocalCache;
    private static Boolean ifMemCached;
    private static Boolean ifRedis;

    private WeChatProperties() {
        ifLocalCache = false;
        ifMemCached = false;
        ifRedis = false;
    }

    public static String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public static String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public static String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public static String getPartnerId() {
        return partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public static String getPartnerKey() {
        return partnerKey;
    }

    public void setPartnerKey(String partnerKey) {
        this.partnerKey = partnerKey;
    }

    public static Boolean getIfLocalCache() {
        return ifLocalCache;
    }

    public void setIfLocalCache(Boolean ifLocalCache) {
        this.ifLocalCache = ifLocalCache;
    }

    public static Boolean getIfMemCached() {
        return ifMemCached;
    }

    public void setIfMemCached(Boolean ifMemCached) {
        this.ifMemCached = ifMemCached;
    }

    public static Boolean getIfRedis() {
        return ifRedis;
    }

    public void setIfRedis(Boolean ifRedis) {
        this.ifRedis = ifRedis;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
    }
}
