package net.oschina.suyeer.fastwechat.util;

import com.alibaba.fastjson.JSONObject;
import net.oschina.suyeer.fastwechat.bean.fwtemplate.FwTemplateBean;
import net.oschina.suyeer.fastwechat.enums.LanguageEnum;
import net.oschina.suyeer.fastwechat.module.WeChatDataCache;

/**
 * Created by jun on 2016/11/29.
 */
public class FwUtil {

    public static String getAccessToken() {
        return WeChatDataCache.getInstance().getAccessToken();
    }

    public static String getJsApiTicket() {
        return WeChatDataCache.getInstance().getJsApiTicket();
    }

    public static JSONObject getUserInfoByOpenId(String openId) {
        String url = String.format(ConstUtil.WX_URL_GET_USER_INFO, getAccessToken(), openId, LanguageEnum.zh_CN.getCode());
        return FwUserUtil.getUserInfo(url);
    }

    public static JSONObject getUserInfoByOpenId(String openId, LanguageEnum languageEnum) {
        String url = String.format(ConstUtil.WX_URL_GET_USER_INFO, getAccessToken(), openId, languageEnum.getCode());
        return FwUserUtil.getUserInfo(url);
    }

    public static JSONObject sendTemplate(FwTemplateBean fwTemplateBean) {
        return FwTemplateUtil.sendTemplate(fwTemplateBean);
    }

}
