/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.suyeer.fastwechat.util.wechat;

import com.alibaba.fastjson.JSONObject;
import net.oschina.suyeer.fastwechat.bean.wechat.fwtemplate.FwTemplateData;
import net.oschina.suyeer.fastwechat.enums.LanguageEnum;
import net.oschina.suyeer.fastwechat.module.WeChatDataCache;
import net.oschina.suyeer.fastwechat.util.common.HttpResUtil;
import net.oschina.suyeer.fastwechat.util.wechat.FwTemplate;

public class FastWeChat {
    public static String getAccessToken() {
        return WeChatDataCache.getInstance().getAccessToken();
    }

    public static String getJsApiTicket() {
        return WeChatDataCache.getInstance().getJsApiTicket();
    }

    public static JSONObject getUserInfoByOpenId(String openId) {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/user/info?access_token=%s&openid=%s&lang=%s", FastWeChat.getAccessToken(), openId, LanguageEnum.zh_CN.getCode());
        return FastWeChat.getUserInfo(url);
    }

    public static JSONObject getUserInfoByOpenId(String openId, LanguageEnum languageEnum) {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/user/info?access_token=%s&openid=%s&lang=%s", FastWeChat.getAccessToken(), openId, languageEnum.getCode());
        return FastWeChat.getUserInfo(url);
    }

    public static JSONObject sendTemplate(FwTemplateData fwTemplateData) {
        return FwTemplate.sendTemplate(fwTemplateData);
    }

    private static JSONObject getUserInfo(String url) {
        JSONObject ret = new JSONObject();
        try {
            ret = HttpResUtil.sendHttpGetRequest(url);
            return ret;
        }
        catch (Exception e) {
            System.err.println("\u8bf7\u6c42\u5fae\u4fe1\u63a5\u53e3\u5931\u8d25 : " + e.getMessage());
        }
        finally {
            return ret;
        }
    }
}

