/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.suyeer.fastwechat.util.common;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oschina.suyeer.fastwechat.bean.common.HttpResContent;
import net.oschina.suyeer.fastwechat.bean.common.MyX509TrustManager;
import net.oschina.suyeer.fastwechat.util.common.JsonUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpResUtil {
    private static Logger logger = Logger.getLogger(HttpResUtil.class);
    private static Boolean ENABLE_JSONP_REQUEST = false;

    public static <T> void writeResContent(HttpResContent<T> httpResContent, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (ENABLE_JSONP_REQUEST.booleanValue()) {
                HttpResUtil.writeResResult4Jsonp(httpResContent, request, response);
            } else {
                HttpResUtil.writeResResult(httpResContent, response);
            }
        }
        catch (Exception var4) {
            logger.error((Object)var4.getMessage());
        }
    }

    public static <T> void writeResResult(HttpResContent<T> httpResContent, HttpServletResponse response) throws Exception {
        try {
            if (response == null) {
                throw new IllegalArgumentException("parameter error.");
            }
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            String jsonRes = JsonUtil.toJsonString(httpResContent);
            PrintWriter pw = response.getWriter();
            pw.write(jsonRes);
            pw.close();
            pw.flush();
        }
        catch (Exception var5) {
            throw new Exception(var5);
        }
    }

    public static <T> void writeResResult4Jsonp(HttpResContent<T> httpResContent, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            if (request == null || response == null) {
                throw new IllegalArgumentException("parameter error.");
            }
            String e = request.getParameter("callback");
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            String jsonRes = JsonUtil.toJsonString(httpResContent);
            String retJsonpS = e + "(" + jsonRes + ")";
            PrintWriter pw = response.getWriter();
            pw.write(retJsonpS);
            pw.close();
            pw.flush();
        }
        catch (Exception var8) {
            throw new Exception(var8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject sendHttpPostRequest(String url, JSONObject params) {
        JSONObject jsonResult = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();
            HttpPost e = new HttpPost(url);
            StringEntity entity = new StringEntity(HttpResUtil.getPostParamStrFromJSONObject(params), ContentType.create((String)"application/x-www-form-urlencoded", (String)"UTF-8"));
            e.setEntity((HttpEntity)entity);
            jsonResult = HttpResUtil.sendRequestAndGetResponseJsonData(httpClient, (HttpUriRequest)e);
        }
        catch (Exception var9) {
            logger.error((Object)("POST\u8bf7\u6c42\u5931\u8d25,URL:" + url), (Throwable)var9);
        }
        finally {
            HttpResUtil.closeHttpClient(httpClient);
        }
        return jsonResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject sendHttpGetRequest(String url) {
        JSONObject jsonResult = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();
            HttpGet e = new HttpGet(url);
            jsonResult = HttpResUtil.sendRequestAndGetResponseJsonData(httpClient, (HttpUriRequest)e);
        }
        catch (Exception var7) {
            logger.error((Object)("GET\u8bf7\u6c42\u5931\u8d25,URL:" + url), (Throwable)var7);
        }
        finally {
            HttpResUtil.closeHttpClient(httpClient);
        }
        return jsonResult;
    }

    private static String getPostParamStrFromJSONObject(JSONObject jsonObj) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : jsonObj.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append((String)entry.getKey() + "=" + entry.getValue());
        }
        return sb.toString();
    }

    private static JSONObject sendRequestAndGetResponseJsonData(CloseableHttpClient chc, HttpUriRequest hur) throws Exception {
        CloseableHttpResponse response = chc.execute(hur);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new Exception("GET\u8bf7\u6c42\u8fd4\u56de\u72b6\u6001\u5f02\u5e38,\u72b6\u6001\u7801:" + statusCode);
        }
        return JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
    }

    private static void closeHttpClient(CloseableHttpClient chc) {
        if (chc != null) {
            try {
                chc.close();
            }
            catch (IOException var2) {
                logger.error((Object)"httpClient\u5bf9\u8c61\u5173\u95ed\u5f02\u5e38");
            }
        }
    }

    public static JSONObject sendSSLPostRequest(String url, String params) {
        return HttpResUtil.sendSSLRequest(url, params, "post");
    }

    public static JSONObject sendSSLGetRequest(String url) {
        return HttpResUtil.sendSSLRequest(url, null, "get");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject sendSSLRequest(String url, String params, String methodType) {
        JSONObject retJson = null;
        try {
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            HttpsURLConnection httpUrlConn = (HttpsURLConnection)new URL(url).openConnection();
            httpUrlConn.setSSLSocketFactory(sslContext.getSocketFactory());
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestMethod(methodType.toUpperCase());
            if (methodType.equalsIgnoreCase("get")) {
                httpUrlConn.connect();
            }
            if (StringUtils.isNotBlank((String)params)) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(params.getBytes("UTF-8"));
                outputStream.close();
            }
            String ss = IOUtils.toString((InputStream)httpUrlConn.getInputStream(), (String)"UTF-8");
            retJson = JSONObject.parseObject((String)ss);
            httpUrlConn.disconnect();
        }
        catch (ConnectException ce) {
            logger.error((Object)("\u53d1\u9001\u8bf7\u6c42\u8d85\u65f6 \uff1a" + ce.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)"\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38 : {}", (Throwable)e);
        }
        finally {
            return retJson;
        }
    }
}

