/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.suyeer.fastwechat.module;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.oschina.suyeer.fastwechat.bean.wechat.base.CacheData;
import net.oschina.suyeer.fastwechat.util.common.ConstUtil;
import net.oschina.suyeer.fastwechat.util.common.DateUtil;
import net.oschina.suyeer.fastwechat.util.common.HttpResUtil;
import org.apache.log4j.Logger;

public class WeChatDataCache {
    private Logger logger = Logger.getLogger(WeChatDataCache.class);
    private final ConcurrentMap<String, CacheData> weChatCacheMap = new ConcurrentHashMap<String, CacheData>();

    public static WeChatDataCache getInstance() {
        return LazyHolder.INSTANCE;
    }

    private WeChatDataCache() {
    }

    private void put(String key, String value) {
        CacheData cacheData = new CacheData();
        cacheData.setValue(value);
        cacheData.setCreateTime(new Date());
        this.weChatCacheMap.put(key, cacheData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String get(String key) {
        String ret = null;
        try {
            if (this.weChatCacheMap.containsKey(key)) {
                CacheData cacheData = (CacheData)this.weChatCacheMap.get(key);
                if (!DateUtil.checkExpired(cacheData.getCreateTime(), ConstUtil.WX_CACHE_KEEP_EXPIRED_SECOND).booleanValue()) {
                    ret = cacheData.getValue();
                    return ret;
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
        finally {
            return ret;
        }
    }

    public String getAccessToken() {
        String ret = null;
        try {
            block7: {
                if (ConstUtil.IF_LOCALCACHE.booleanValue()) {
                    ret = this.get("WX_KEY_ACCESS_TOKEN");
                }
                if (ret != null) break block7;
                JSONObject obj = HttpResUtil.sendHttpGetRequest(ConstUtil.WX_URL_CGI_BIN_ACCESS_TOKEN);
                if (obj == null) break;
                if (obj.containsKey((Object)"access_token")) {
                    ret = obj.getString("access_token");
                    this.put("WX_KEY_ACCESS_TOKEN", ret);
                }
                break;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("\u83b7\u53d6AccessToken\u5931\u8d25 : " + e.getMessage()));
        }
        finally {
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJsApiTicket() {
        String ret = null;
        try {
            block7: {
                if (ConstUtil.IF_LOCALCACHE.booleanValue()) {
                    ret = this.get("WX_KEY_JS_API_TICKET");
                }
                if (ret != null) break block7;
                String accessToken = this.getAccessToken();
                if (accessToken == null) break;
                JSONObject obj = HttpResUtil.sendHttpGetRequest("https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi&access_token=" + accessToken);
                if (obj == null) break;
                if (obj.containsKey((Object)"ticket")) {
                    ret = obj.getString("ticket");
                    this.put("WX_KEY_JS_API_TICKET", ret);
                }
                break;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("\u83b7\u53d6JsApiTicket\u5931\u8d25 : " + e.getMessage()));
        }
        finally {
            return ret;
        }
    }

    private static class LazyHolder {
        private static final WeChatDataCache INSTANCE = new WeChatDataCache();

        private LazyHolder() {
        }
    }
}

