package net.oschina.suyeer.fastwechat.util.wechat;

import com.alibaba.fastjson.JSONObject;
import net.oschina.suyeer.fastwechat.bean.wechat.fwtemplate.FwTemplateData;
import net.oschina.suyeer.fastwechat.util.common.HttpResUtil;
import net.oschina.suyeer.fastwechat.util.common.JsonUtil;
import org.apache.log4j.Logger;

import static net.oschina.suyeer.fastwechat.util.common.ConstUtil.WX_URL_SEND_TEMPLATE_MESSAGE;

/**
 * 模板消息方法
 * Created by jun on 2017/2/6.
 */
public class FwTemplate {
    private static Logger logger = Logger.getLogger(FwMenu.class);

    /**
     * 发送模板消息
     */
    public static JSONObject sendTemplate(FwTemplateData fwTemplateData) {
        JSONObject retObj = new JSONObject();
        try {
            retObj = HttpResUtil.sendSSLPostRequest(WX_URL_SEND_TEMPLATE_MESSAGE + FastWeChat.getAccessToken(), JsonUtil.toJsonString(fwTemplateData));
        } catch (Exception e) {
            logger.error("发送请求异常 : {}", e);
        }
        return retObj;
    }
}
