package net.oschina.suyeer.fastwechat.util.wechat;

import net.oschina.suyeer.fastwechat.bean.wechat.fwpay.FwPrepay;
import net.oschina.suyeer.fastwechat.util.common.EncryptUtil;
import net.oschina.suyeer.fastwechat.util.common.JsonUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;

import java.util.Map;
import java.util.TreeMap;

import static net.oschina.suyeer.fastwechat.util.common.ConstUtil.DEFAULT_ENCODE;
import static net.oschina.suyeer.fastwechat.util.common.ConstUtil.STRING_EMPTY;
import static net.oschina.suyeer.fastwechat.util.common.ConstUtil.unifiedorder;

/**
 * Created by jun on 2017/2/9.
 */
public class FwPay {

    private static Logger logger = Logger.getLogger(FwPay.class);

    public static String getPackage(FwPrepay fwPrepay) {
        TreeMap<String, String> treeMap = JsonUtil.changeType(fwPrepay, TreeMap.class);
        treeMap.remove("sign");
        treeMap.remove("prepay_id");
        StringBuilder sb = new StringBuilder();
        for (String key : treeMap.keySet()) {
            sb.append(key).append("=").append(treeMap.get(key)).append("&");
        }
        sb.append("key=" + fwPrepay.getPartnerKey());
        fwPrepay.setSign(EncryptUtil.MD5(sb.toString().toUpperCase()));
        treeMap.put("sign", fwPrepay.getSign());
        StringBuilder xml = new StringBuilder();
        xml.append("<xml>\n");
        for (Map.Entry<String, String> entry : treeMap.entrySet()) {
            xml.append("<" + entry.getKey() + ">").append(entry.getValue()).append("</" + entry.getKey() + ">\n");
        }
        xml.append("</xml>");
        System.err.println(xml.toString());
        return xml.toString();
    }

    public static String submitXmlGetPrepayId(FwPrepay fwPrepay) {
        // 创建HttpClientBuilder
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        // HttpClient
        CloseableHttpClient closeableHttpClient = httpClientBuilder.build();
        HttpPost httpPost = new HttpPost(unifiedorder);
        String xml = getPackage(fwPrepay);
        StringEntity entity;
        String prepay_id = STRING_EMPTY;
        try {
            entity = new StringEntity(xml, DEFAULT_ENCODE);
            httpPost.setEntity(entity);
            HttpResponse httpResponse;
            // post请求
            httpResponse = closeableHttpClient.execute(httpPost);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                // 打印响应内容
                String result = EntityUtils.toString(httpEntity, DEFAULT_ENCODE);
                System.err.println(result);
                // 过滤
                result = result.replaceAll("<![CDATA[|]]>", STRING_EMPTY);
                prepay_id = Jsoup.parse(result).select("prepay_id").html();
                fwPrepay.setPrepay_id(prepay_id);
                if (prepay_id != null)
                    return prepay_id;
            }
            // 释放资源
            closeableHttpClient.close();
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return prepay_id;
    }
}
