package net.oschina.suyeer.fastwechat.util.wechat;

import com.alibaba.fastjson.JSONObject;
import net.oschina.suyeer.fastwechat.bean.wechat.fwtemplate.FwTemplateData;
import net.oschina.suyeer.fastwechat.enums.LanguageEnum;
import net.oschina.suyeer.fastwechat.module.WeChatDataCache;
import net.oschina.suyeer.fastwechat.util.common.ConstUtil;
import net.oschina.suyeer.fastwechat.util.common.HttpResUtil;

/**
 * Created by jun on 2016/11/29.
 */
public class FastWeChat {

    public static String getAccessToken() {
        return WeChatDataCache.getInstance().getAccessToken();
    }

    public static String getJsApiTicket() {
        return WeChatDataCache.getInstance().getJsApiTicket();
    }

    public static JSONObject getUserInfoByOpenId(String openId) {
        String url = String.format(ConstUtil.WX_URL_GET_USER_INFO, getAccessToken(), openId, LanguageEnum.zh_CN.getCode());
        return getUserInfo(url);
    }

    public static JSONObject getUserInfoByOpenId(String openId, LanguageEnum languageEnum) {
        String url = String.format(ConstUtil.WX_URL_GET_USER_INFO, getAccessToken(), openId, languageEnum.getCode());
        return getUserInfo(url);
    }

    public static JSONObject sendTemplate(FwTemplateData fwTemplateData) {
        return FwTemplate.sendTemplate(fwTemplateData);
    }

    private static JSONObject getUserInfo(String url) {
        JSONObject ret = new JSONObject();
        try {
            ret = HttpResUtil.sendHttpGetRequest(url);
        } catch (Exception e) {
            System.err.println("请求微信接口失败 : " + e.getMessage());
        } finally {
            return ret;
        }
    }

}
