package net.oschina.suyeer.fastwechat.module;

import com.alibaba.fastjson.JSONObject;
import net.oschina.suyeer.fastwechat.bean.wechat.base.CacheData;
import net.oschina.suyeer.fastwechat.util.common.ConstUtil;
import net.oschina.suyeer.fastwechat.util.common.DateUtil;
import net.oschina.suyeer.fastwechat.util.common.HttpResUtil;
import org.apache.log4j.Logger;

import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * Created by jun on 2016/11/29.
 */
public class WeChatDataCache {
    private static class LazyHolder {
        private static final WeChatDataCache INSTANCE = new WeChatDataCache();
    }

    public static WeChatDataCache getInstance() {
        return WeChatDataCache.LazyHolder.INSTANCE;
    }

    private WeChatDataCache() {
    }

    private Logger logger = Logger.getLogger(WeChatDataCache.class);

    /**
     * 微信缓存, 如 accessToken
     */
    private final ConcurrentMap<String, CacheData> weChatCacheMap = new ConcurrentHashMap<>();

    private void put(String key, String value) {
        CacheData cacheData = new CacheData();
        cacheData.setValue(value);
        cacheData.setCreateTime(new Date());
        weChatCacheMap.put(key, cacheData);
    }

    private String get(String key) {
        String ret = null;
        try {
            if (weChatCacheMap.containsKey(key)) {
                CacheData cacheData = weChatCacheMap.get(key);
                if (!DateUtil.checkExpired(cacheData.getCreateTime(), ConstUtil.WX_CACHE_KEEP_EXPIRED_SECOND)) {
                    ret = cacheData.getValue();
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        } finally {
            return ret;
        }
    }

    public String getAccessToken() {
        String ret = null;
        try {
            if (ConstUtil.IF_LOCALCACHE) {
                ret = get(ConstUtil.WX_KEY_ACCESS_TOKEN);
            }
            if (ret == null) {
                JSONObject obj = HttpResUtil.sendHttpGetRequest(ConstUtil.WX_URL_CGI_BIN_ACCESS_TOKEN);
                if (obj != null && obj.containsKey(ConstUtil.WX_PARAMETER_ACCESS_TOKEN)) {
                    ret = obj.getString(ConstUtil.WX_PARAMETER_ACCESS_TOKEN);
                    put(ConstUtil.WX_KEY_ACCESS_TOKEN, ret);
                }
            }
        } catch (Exception e) {
            logger.error("获取AccessToken失败 : " + e.getMessage());
        } finally {
            return ret;
        }
    }

    public String getJsApiTicket() {
        String ret = null;
        try {
            if (ConstUtil.IF_LOCALCACHE) {
                ret = get(ConstUtil.WX_KEY_JS_API_TICKET);
            }
            if (ret == null) {
                String accessToken = getAccessToken();
                if (accessToken != null) {
                    JSONObject obj = HttpResUtil.sendHttpGetRequest(ConstUtil.WX_URL_GET_JS_API_TICKET + accessToken);
                    if (obj != null && obj.containsKey(ConstUtil.WX_PARAMETER_TICKET)) {
                        ret = obj.getString(ConstUtil.WX_PARAMETER_TICKET);
                        put(ConstUtil.WX_KEY_JS_API_TICKET, ret);
                    }
                }
            }
        } catch (Exception e) {
            logger.error("获取JsApiTicket失败 : " + e.getMessage());
        } finally {
            return ret;
        }
    }

}

