/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.suyeer.basic.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;
import net.oschina.suyeer.basic.util.BEncryptUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicUtil {
    private static Logger logger = LoggerFactory.getLogger(BasicUtil.class);

    public static String getUserIp(HttpServletRequest request) {
        String ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) && ((ipAddress = request.getRemoteAddr()).equals("127.0.0.1") || ipAddress.equals("0:0:0:0:0:0:0:1"))) {
            InetAddress ine = null;
            try {
                ine = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                logger.error("\u83b7\u53d6\u7528\u6237ip\u5931\u8d25!", e.getCause());
            }
            ipAddress = ine.getHostAddress();
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getNonceStr() {
        return BEncryptUtil.MD5(BasicUtil.getUUID());
    }

    public static List<String> getList(String srcStr) {
        return BasicUtil.getList(srcStr, ",");
    }

    public static List<String> getList(String srcStr, String separatorStr) {
        ArrayList<String> retList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)srcStr) && StringUtils.isNotBlank((String)separatorStr)) {
            String[] arr;
            for (String s : arr = srcStr.split(separatorStr)) {
                if (!StringUtils.isNotBlank((String)s)) continue;
                retList.add(s.trim());
            }
        }
        return retList;
    }

    public static SSLSocketFactory createSSLSocketFactory(String var0, String var1) throws NoSuchAlgorithmException, KeyManagementException, NoSuchProviderException {
        SSLContext sslContext = var1 != null ? SSLContext.getInstance(var0, var1) : SSLContext.getInstance(var0);
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        return sslContext.getSocketFactory();
    }

    public static HostnameVerifier createHostnameVerifier(final Boolean verify) {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return verify;
            }
        };
    }
}

