/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.suyeer.basic.util;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import net.oschina.suyeer.basic.bean.BRSAKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class BRSAUtil {
    private static Logger logger = LoggerFactory.getLogger(BRSAUtil.class);

    public static String encrypt(String data, String publicKeyStr) throws Exception {
        KeyFactory factory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(new BASE64Decoder().decodeBuffer(publicKeyStr));
        PublicKey publicKey = factory.generatePublic(x509EncodedKeySpec);
        return BRSAUtil.encrypt(data, publicKey);
    }

    public static String encrypt(String data, PublicKey publicKey) throws Exception {
        BASE64Encoder base64Encoder = new BASE64Encoder();
        byte[] tmp1 = data.getBytes();
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        byte[] tmp2 = cipher.doFinal(tmp1);
        return base64Encoder.encode(tmp2);
    }

    public static String decrypt(String base64Str, String privateKeyStr) throws Exception {
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(new BASE64Decoder().decodeBuffer(privateKeyStr));
        PrivateKey privateKey = factory.generatePrivate(pkcs8EncodedKeySpec);
        return BRSAUtil.decrypt(base64Str, privateKey);
    }

    public static String decrypt(String base64Str, PrivateKey privateKey) throws Exception {
        BASE64Decoder base64Decoder = new BASE64Decoder();
        byte[] tmp1 = base64Decoder.decodeBuffer(base64Str);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        byte[] tmp2 = cipher.doFinal(tmp1);
        return new String(tmp2);
    }

    public static void main(String[] arg) {
        try {
            String data = "This is test data!";
            BRSAKey rsaKey = new BRSAKey();
            String tmp1 = BRSAUtil.encrypt(data, rsaKey.getPublicKey());
            System.err.println("\n\u52a0\u5bc6\u540e\uff1a\n\n" + tmp1);
            String tmp2 = BRSAUtil.decrypt(tmp1, rsaKey.getPrivateKey());
            System.err.println("\n\u89e3\u5bc6\u540e\uff1a\n\n" + tmp2);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }
}

