package net.oschina.suyeer.basic.util;

import net.oschina.suyeer.basic.bean.BRSAKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import javax.crypto.Cipher;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

import static net.oschina.suyeer.basic.util.BConstUtil.KEY_ALGORITHM;

/**
 * Created by jun on 2017/10/23.
 */
public class BRSAUtil {
    private static Logger logger = LoggerFactory.getLogger(BRSAUtil.class);

    /**
     * User: jun
     * Date: 2017/10/24
     * Desc: 公钥加密
     */
    public static String encrypt(String data, String publicKeyStr) throws Exception {
        KeyFactory factory = KeyFactory.getInstance(KEY_ALGORITHM);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(
                new BASE64Decoder().decodeBuffer(publicKeyStr));
        PublicKey publicKey = factory.generatePublic(x509EncodedKeySpec);
        return encrypt(data, publicKey);
    }

    /**
     * User: jun
     * Date: 2017/10/24
     * Desc: 公钥加密
     */
    public static String encrypt(String data, PublicKey publicKey) throws Exception {
        BASE64Encoder base64Encoder = new BASE64Encoder();
        byte[] tmp1 = data.getBytes();
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(Cipher.ENCRYPT_MODE, publicKey);
        byte[] tmp2 = cipher.doFinal(tmp1);
        return base64Encoder.encode(tmp2);
    }

    /**
     * User: jun
     * Date: 2017/10/24
     * Desc: 利用私钥解密
     */
    public static String decrypt(String base64Str, String privateKeyStr) throws Exception {
        KeyFactory factory = KeyFactory.getInstance(KEY_ALGORITHM);
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(
                new BASE64Decoder().decodeBuffer(privateKeyStr));
        PrivateKey privateKey = factory.generatePrivate(pkcs8EncodedKeySpec);
        return decrypt(base64Str, privateKey);
    }

    /**
     * User: jun
     * Date: 2017/10/24
     * Desc: 利用私钥解密
     */
    public static String decrypt(String base64Str, PrivateKey privateKey) throws Exception {
        BASE64Decoder base64Decoder = new BASE64Decoder();
        byte[] tmp1 = base64Decoder.decodeBuffer(base64Str);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(Cipher.DECRYPT_MODE, privateKey);
        byte[] tmp2 = cipher.doFinal(tmp1);
        return new String(tmp2);
    }

    public static void main(String[] arg) {
        try {
            String data = "This is test data!";
            BRSAKey rsaKey = new BRSAKey();
            //公钥加密
            String tmp1 = encrypt(data, rsaKey.getPublicKey());
            System.err.println("\n加密后：\n\n" + tmp1);

            //私钥解密
            String tmp2 = decrypt(tmp1, rsaKey.getPrivateKey());
            System.err.println("\n解密后：\n\n" + tmp2);
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

}
