package net.oschina.suyeer.basic.bean;

import sun.misc.BASE64Encoder;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;

import static net.oschina.suyeer.basic.util.BConstUtil.DEFAULT_LENGTH;
import static net.oschina.suyeer.basic.util.BConstUtil.KEY_ALGORITHM;

/**
 * Created by jun on 2017/10/25.
 */
public class BRSAKey {
    private String privateKey;
    private String publicKey;

    public BRSAKey() {
        this(DEFAULT_LENGTH);
    }

    public BRSAKey(int length) {
        try {
            BASE64Encoder base64Encoder = new BASE64Encoder();
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyPairGenerator.initialize(length);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();

            //base64格式公钥
            PublicKey publicKey = keyPair.getPublic();
            this.publicKey = base64Encoder.encode(publicKey.getEncoded());

            //base64格式私钥
            PrivateKey privateKey = keyPair.getPrivate();
            this.privateKey = base64Encoder.encode(privateKey.getEncoded());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getPrivateKey() {
        return privateKey;
    }

    public String getPublicKey() {
        return publicKey;
    }
}
