package net.oschina.suyeer.basic.log4j;

import com.alibaba.fastjson.JSON;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

/**
 * Created by jun on 2018/1/12.
 */
public class Log4JdbcLoggingEvent extends LoggingEvent {
    private static final long serialVersionUID = -1488678823444745177L;

    public Log4JdbcLoggingEvent(String fqnOfCategoryClass, Category logger, Priority level, Object message) {
        super(fqnOfCategoryClass, logger, level, message, null);
    }

    @Override
    public String getThreadName() {
        return replace(super.getThreadName());
    }

    @Override
    public String getRenderedMessage() {
        return replace(super.getRenderedMessage());
    }

    @Override
    public String getNDC() {
        return replace(super.getNDC());
    }

    @Override
    public Object getMDC(String key) {
        Object obj = super.getMDC(key);
        if (obj == null) {
            return null;
        }
        return replace(JSON.toJSONString(obj));
    }

    private String replace(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("'", "''").replaceAll("\"", "");
    }
}
