/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.suyeer.basic.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.time.DateUtils;

public class BDateUtil {
    private static String dateFormatStr = "yyyy-MM-dd HH:mm:ss";
    private static String shortDateFormatStr = "yyyy-MM-dd";
    private static String monthDateFormatStr = "yyyy\u5e74MM\u6708";
    private static String shortTimeFormatStr = "yyyyMMddHHmmssSSS";
    private static String timeFormatStr = "HH:mm:ss";

    public static String getDateStr(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(dateFormatStr);
        return df.format(date);
    }

    public static String getOnlyTimeStr(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(timeFormatStr);
        return df.format(date);
    }

    public static String getShortDateStr(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(shortDateFormatStr);
        return df.format(date);
    }

    public static String getDayStr(Date date) {
        return new SimpleDateFormat("dd\u65e5").format(date);
    }

    public static String getMonthStr(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(monthDateFormatStr);
        return df.format(date);
    }

    public static Date getDateByIndex(int index) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        cal.add(5, index);
        return cal.getTime();
    }

    public static String getDateStr(int year, int month, int day) {
        Date dt = new Date();
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(dt);
        rightNow.add(1, year);
        rightNow.add(2, month);
        rightNow.add(6, day);
        Date newDate = rightNow.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(shortDateFormatStr);
        return sdf.format(newDate);
    }

    public static Date getDateFromStr(String dateStr) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(dateFormatStr);
        return df.parse(dateStr);
    }

    public static String getShortTimeFormStr(Date d) {
        SimpleDateFormat df = new SimpleDateFormat(shortTimeFormatStr);
        return df.format(d);
    }

    public static Boolean isSameDay(Date d1, Date d2) {
        SimpleDateFormat df = new SimpleDateFormat(shortDateFormatStr);
        String str1 = df.format(d1);
        String str2 = df.format(d2);
        return str1.equals(str2);
    }

    public static Boolean checkExpired(Date date, int expiredSecond) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.add(13, expiredSecond);
        Date expiredDate = gc.getTime();
        return expiredDate.getTime() < new Date().getTime();
    }

    public static Integer getSecondResult4SubTime(Date d1, Date d2) {
        long ms = d2.getTime() - d1.getTime();
        return (int)(ms / 1000L);
    }

    public static Date getFutureDate(Date date, int seconds) {
        return DateUtils.addSeconds((Date)date, (int)seconds);
    }

    public static Date getFutureDate(int seconds) {
        return BDateUtil.getFutureDate(new Date(), seconds);
    }

    public static String getTimestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }
}

