package net.oschina.suyeer.basic.util;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.*;
import javax.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * Created by jun on 2017/2/15.
 */
public class BasicUtil {

    private static Logger logger = LoggerFactory.getLogger(BasicUtil.class);

    public static String getUserIp(HttpServletRequest request) {
        String ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getRemoteAddr();
            if (ipAddress.equals("127.0.0.1") || ipAddress.equals("0:0:0:0:0:0:0:1")) {
                InetAddress ine = null;
                try {
                    ine = InetAddress.getLocalHost();
                } catch (UnknownHostException e) {
                    logger.error("获取用户ip失败!", e.getCause());
                }
                ipAddress = ine.getHostAddress();
            }
        }
        if (ipAddress != null && ipAddress.length() > 15) {
            if (ipAddress.indexOf(",") > 0) {
                ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
            }
        }
        return ipAddress;
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getNonceStr() {
        return BEncryptUtil.MD5(getUUID());
    }

    public static List<String> getList(String srcStr) {
        return getList(srcStr, ",");
    }

    public static List<String> getList(String srcStr, String separatorStr) {
        List<String> retList = new ArrayList<>();
        if (StringUtils.isNotBlank(srcStr) && StringUtils.isNotBlank(separatorStr)) {
            String arr[] = srcStr.split(separatorStr);
            for (String s : arr) {
                if (StringUtils.isNotBlank(s)) {
                    retList.add(s.trim());
                }
            }
        }
        return retList;
    }

    public static SSLSocketFactory createSSLSocketFactory(String var0, String var1) throws NoSuchAlgorithmException, KeyManagementException, NoSuchProviderException {
        SSLContext sslContext = var1 != null ? SSLContext.getInstance(var0, var1) : SSLContext.getInstance(var0);
        X509TrustManager trustManager = new X509TrustManager() {
            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        return sslContext.getSocketFactory();
    }

    public static HostnameVerifier createHostnameVerifier(Boolean verify) {
        return new HostnameVerifier() {
            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return verify;
            }
        };
    }

}
