/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.suyeer.basic.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.http.HttpServletResponse;
import net.oschina.suyeer.basic.bean.BHttpResContent;
import net.oschina.suyeer.basic.util.BJsonUtil;
import net.oschina.suyeer.basic.util.BasicUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BHttpResUtil {
    private static Logger logger = LoggerFactory.getLogger(BHttpResUtil.class);

    public static <T> void writeResResult(BHttpResContent<T> bHttpResContent, HttpServletResponse response) {
        try {
            if (response == null) {
                throw new IllegalArgumentException("parameter error!");
            }
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            String retStr = BJsonUtil.toString(bHttpResContent);
            PrintWriter pw = response.getWriter();
            pw.write(retStr);
            pw.close();
            pw.flush();
        }
        catch (Exception e) {
            logger.error("\u8fd4\u56de\u6570\u636e\u5f02\u5e38: {}", (Object)e.getMessage());
        }
    }

    public static <T> void writeResResult4JSONP(BHttpResContent<T> bHttpResContent, HttpServletResponse response) {
        try {
            if (response == null) {
                throw new IllegalArgumentException("parameter error!");
            }
            String param = JSON.parseObject((String)bHttpResContent.getReqParams()).getJSONArray("callback").getString(0);
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            String retStr = String.format("%s(%s)", param, BJsonUtil.toString(bHttpResContent));
            PrintWriter pw = response.getWriter();
            pw.write(retStr);
            pw.close();
            pw.flush();
        }
        catch (Exception e) {
            logger.error("\u8fd4\u56de\u6570\u636e\u5f02\u5e38: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject sendHttpPostRequest(String url, JSONObject params) {
        JSONObject retObj = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(BHttpResUtil.getParamStr(params), ContentType.create((String)"application/x-www-form-urlencoded", (String)"UTF-8"));
            httpPost.setEntity((HttpEntity)entity);
            retObj = BHttpResUtil.sendRequest(httpClient, (HttpUriRequest)httpPost);
            return retObj;
        }
        catch (Exception e) {
            logger.error("POST\u8bf7\u6c42\u5931\u8d25,URL: {}, Message: {}", new Object[]{url, e.getMessage(), e});
        }
        finally {
            BHttpResUtil.closeHttpClient(httpClient);
            return retObj;
        }
    }

    private static String getParamStr(JSONObject params) {
        StringBuilder sb = new StringBuilder();
        if (params != null) {
            for (String k : params.keySet()) {
                sb.append(String.format("%s=%s&", k, params.getString(k)));
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpPostRequest(String url, String xmlString) {
        String retStr = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(StringUtils.isBlank((String)xmlString) ? "" : xmlString, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                retStr = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                return retStr;
            }
        }
        catch (Exception e) {
            logger.error("POST\u8bf7\u6c42\u5931\u8d25,URL: {}, Message: {}", (Object)url, (Object)e.getMessage());
        }
        finally {
            BHttpResUtil.closeHttpClient(httpClient);
            return retStr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject sendHttpGetRequest(String url) {
        JSONObject retObj = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(url);
            retObj = BHttpResUtil.sendRequest(httpClient, (HttpUriRequest)httpGet);
            return retObj;
        }
        catch (Exception e) {
            logger.error("GET\u8bf7\u6c42\u5931\u8d25,URL: {}, Message: {}", (Object)url, (Object)e.getMessage());
        }
        finally {
            BHttpResUtil.closeHttpClient(httpClient);
            return retObj;
        }
    }

    private static JSONObject sendRequest(CloseableHttpClient chc, HttpUriRequest hur) throws Exception {
        CloseableHttpResponse response = chc.execute(hur);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new Exception("\u8bf7\u6c42\u8fd4\u56de\u72b6\u6001\u5f02\u5e38,\u72b6\u6001\u7801: " + statusCode);
        }
        return JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
    }

    private static void closeHttpClient(CloseableHttpClient chc) {
        if (chc != null) {
            try {
                chc.close();
            }
            catch (IOException e) {
                logger.error("httpClient\u5bf9\u8c61\u5173\u95ed\u5f02\u5e38: {}", (Object)e.getMessage());
            }
        }
    }

    public static JSONObject sendSSLPostRequest(String url, JSONObject params) {
        return BHttpResUtil.sendSSLRequest(url, BHttpResUtil.getParamStr(params), "POST");
    }

    public static JSONObject sendSSLPostRequest(String url, String jsonString) {
        return BHttpResUtil.sendSSLRequest(url, jsonString, "POST");
    }

    public static JSONObject sendSSLGetRequest(String url) {
        return BHttpResUtil.sendSSLRequest(url, null, "GET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject sendSSLRequest(String url, String params, String methodType) {
        JSONObject retJson = null;
        try {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)new URL(url).openConnection();
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setUseCaches(false);
            httpsURLConnection.setRequestMethod(methodType);
            httpsURLConnection.setHostnameVerifier(BasicUtil.createHostnameVerifier(true));
            httpsURLConnection.setSSLSocketFactory(BasicUtil.createSSLSocketFactory("SSL", "SunJSSE"));
            if (methodType.equals("GET")) {
                httpsURLConnection.connect();
            }
            if (StringUtils.isNotBlank((String)params)) {
                OutputStream outputStream = httpsURLConnection.getOutputStream();
                outputStream.write(params.getBytes("UTF-8"));
                outputStream.close();
            }
            String retStr = IOUtils.toString((InputStream)httpsURLConnection.getInputStream(), (String)"UTF-8");
            retJson = JSONObject.parseObject((String)retStr);
            httpsURLConnection.disconnect();
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38: {}", (Object)e.getMessage());
        }
        finally {
            return retJson;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject sendHttpFilePostRequest(String urlStr, JSONObject params) throws Exception {
        String BOUNDARY = "----MyFormBoundarySMFEtUYQG6r5B920";
        HttpURLConnection hc = null;
        String retStr = null;
        try {
            URL url = new URL(urlStr);
            hc = (HttpURLConnection)url.openConnection();
            hc.setRequestProperty("Content-Type", "multipart/form-data; boundary=----MyFormBoundarySMFEtUYQG6r5B920");
            hc.setRequestProperty("Charsert", "UTF-8");
            hc.setDoOutput(true);
            hc.setDoInput(true);
            hc.setUseCaches(false);
            hc.setRequestMethod("POST");
            OutputStream dout = hc.getOutputStream();
            String boundary = "----MyFormBoundarySMFEtUYQG6r5B920";
            StringBuffer resSB = new StringBuffer("\r\n");
            String endBoundary = "\r\n--" + boundary + "--\r\n";
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                String value = entry.getValue().toString();
                if (!StringUtils.isNotBlank((String)key)) continue;
                resSB.append(String.format("Content-Disposition: form-data; name=%s\r\n\r\n%s\r\n--%s\r\n", key, value, boundary));
            }
            String boundaryMessage = resSB.toString();
            dout.write(("--" + boundary + boundaryMessage).getBytes("UTF-8"));
            resSB = new StringBuffer();
            resSB.append("Content-Disposition: form-data; name=Filedata; filename=class_img.jpg\r\nContent-Type: image/jpeg\r\n\r\n");
            dout.write(resSB.toString().getBytes("UTF-8"));
            URL fileUrl = new URL(params.getString("file"));
            DataInputStream in = new DataInputStream(fileUrl.openConnection().getInputStream());
            dout.write(IOUtils.toByteArray((InputStream)in));
            in.close();
            dout.write(endBoundary.getBytes("UTF-8"));
            dout.close();
            retStr = IOUtils.toString((InputStream)hc.getInputStream(), (String)"UTF-8");
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25: {}", (Object)e.getMessage());
        }
        finally {
            try {
                hc.disconnect();
            }
            catch (Exception e) {
                logger.error("\u5bf9\u8c61\u5173\u95ed\u5f02\u5e38: {}", (Object)e.getMessage());
            }
        }
        return JSONObject.parseObject(retStr);
    }
}

