/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.suyeer.basic.bean;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.oschina.suyeer.basic.util.BJsonUtil;
import net.oschina.suyeer.basic.util.BasicUtil;
import org.apache.commons.lang.StringUtils;

public class BHttpResContent<T>
implements Serializable {
    private static final long serialVersionUID = -5764986016352461610L;
    private Integer code = 200;
    private String message = "";
    private T result;
    private transient String funcDes;
    private transient Boolean isLogin = false;
    private transient Object userInfo;
    private transient String userIp = "";
    private transient String reqURL = "";
    private transient String reqURI = "";
    private transient String reqQueryURL = "";
    private transient String reqQueryURI = "";
    private transient String reqQuery;
    private transient String reqMethod;
    private transient String reqParams = "";
    private transient String sessionId;
    private transient HttpSession httpSession;

    public BHttpResContent(HttpServletRequest request) {
        if (request != null) {
            this.reqQuery = StringUtils.isNotBlank((String)request.getQueryString()) ? "?" + request.getQueryString() : "";
            this.reqURI = request.getRequestURI();
            this.reqURL = request.getRequestURL().toString();
            this.reqQueryURI = this.reqURI + this.reqQuery;
            this.reqQueryURL = this.reqURL + this.reqQuery;
            this.reqParams = BJsonUtil.toString(request.getParameterMap());
            this.reqMethod = request.getMethod();
            this.httpSession = request.getSession();
            this.userIp = BasicUtil.getUserIp(request);
            if (this.httpSession != null) {
                this.sessionId = this.httpSession.getId();
                this.userInfo = this.httpSession.getAttribute("SESSION_CURRENT_LOGIN_USER_INFO");
            }
            this.isLogin = this.userInfo != null;
        }
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public void fillData(Integer code, String message, T result) {
        this.code = code;
        this.message = message;
        this.result = result;
    }

    public String getReqParams() {
        return this.reqParams;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public Object getUserInfo() {
        return this.userInfo;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public String getReqMethod() {
        return this.reqMethod;
    }

    public Boolean isLogin() {
        return this.isLogin;
    }

    public String getFuncDes() {
        return this.funcDes;
    }

    public void setFuncDes(String funcDes) {
        this.funcDes = funcDes;
    }

    public String getReqURL() {
        return this.reqURL;
    }

    public String getReqURI() {
        return this.reqURI;
    }

    public String getReqQueryURL() {
        return this.reqQueryURL;
    }

    public String getReqQueryURI() {
        return this.reqQueryURI;
    }

    public String getReqQuery() {
        return this.reqQuery;
    }
}

