/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.suyeer.basic.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import net.oschina.suyeer.basic.util.BEncryptUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BasicUtil {
    private static Logger logger = Logger.getLogger(BasicUtil.class);

    public static String getUserIp(HttpServletRequest request) {
        String ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) && ((ipAddress = request.getRemoteAddr()).equals("127.0.0.1") || ipAddress.equals("0:0:0:0:0:0:0:1"))) {
            InetAddress ine = null;
            try {
                ine = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                logger.error((Object)"\u83b7\u53d6\u7528\u6237ip\u5931\u8d25!", (Throwable)e);
            }
            ipAddress = ine.getHostAddress();
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getNonceStr() {
        return BEncryptUtil.MD5(BasicUtil.getUUID());
    }

    public static List<String> getList(String srcStr) {
        return BasicUtil.getList(srcStr, ",");
    }

    public static List<String> getList(String srcStr, String separatorStr) {
        ArrayList<String> retList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)srcStr) && StringUtils.isNotBlank((String)separatorStr)) {
            String[] arr;
            for (String s : arr = srcStr.split(separatorStr)) {
                if (!StringUtils.isNotBlank((String)s)) continue;
                retList.add(s.trim());
            }
        }
        return retList;
    }
}

