package net.oschina.suyeer.basic.bean;

import net.oschina.suyeer.basic.util.BJsonUtil;
import net.oschina.suyeer.basic.util.BasicUtil;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.io.Serializable;

import static net.oschina.suyeer.basic.util.BConstUtil.SESSION_CURRENT_LOGIN_USER_INFO;

/**
 * Created by jun on 2017/2/16.
 */
public class BHttpResContent<T> implements Serializable {
    private static final long serialVersionUID = -5764986016352461610L;
    private Integer code;
    private String message;
    private T result;
    private transient String funcDes;
    private transient Boolean isLogin;
    private transient Object userInfo;
    private transient String userIp;
    private transient String reqUrl;
    private transient String reqMethod;
    private transient String reqParams;
    private transient String sessionId;
    private transient HttpSession httpSession;

    public BHttpResContent() {
        this.code = Integer.valueOf(200);
        this.message = "";
        this.reqUrl = "";
        this.reqParams = "";
        this.userIp = "";
        this.isLogin = false;
    }

    public BHttpResContent(HttpServletRequest request) {
        if (request != null) {
            this.reqUrl = request.getRequestURI();
            this.reqParams = BJsonUtil.toJsonString(request.getParameterMap());
            this.reqMethod = request.getMethod();
            this.httpSession = request.getSession();
            this.userIp = BasicUtil.getUserIp(request);
            if (this.httpSession != null) {
                this.sessionId = this.httpSession.getId();
                this.userInfo = this.httpSession.getAttribute(SESSION_CURRENT_LOGIN_USER_INFO);
            }
            this.isLogin = (this.userInfo != null);
        }

    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public void fillData(Integer code, String message, T result) {
        this.code = code;
        this.message = message;
        this.result = result;
    }

    public String getReqUrl() {
        return this.reqUrl;
    }

    public String getReqParams() {
        return this.reqParams;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public Object getUserInfo() {
        return this.userInfo;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public String getReqMethod() {
        return this.reqMethod;
    }

    public Boolean isLogin() {
        return this.isLogin;
    }

    public String getFuncDes() {
        return funcDes;
    }

    public void setFuncDes(String funcDes) {
        this.funcDes = funcDes;
    }
}
