/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.suyeer.basic.util;

import com.alibaba.fastjson.JSONObject;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oschina.suyeer.basic.bean.BHttpResContent;
import net.oschina.suyeer.basic.bean.MyX509TrustManager;
import net.oschina.suyeer.basic.util.BJsonUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class BHttpResUtil {
    private static Logger logger = Logger.getLogger(BHttpResUtil.class);

    public static <T> void writeResResult(BHttpResContent<T> httpResContent, HttpServletResponse response) {
        try {
            if (response == null) {
                throw new IllegalArgumentException("parameter error.");
            }
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            String jsonRes = BJsonUtil.toJsonString(httpResContent);
            PrintWriter pw = response.getWriter();
            pw.write(jsonRes);
            pw.close();
            pw.flush();
        }
        catch (Exception var5) {
            logger.error((Object)var5);
        }
    }

    public static <T> void writeResResult4Jsonp(BHttpResContent<T> httpResContent, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (request == null || response == null) {
                throw new IllegalArgumentException("parameter error.");
            }
            String e = request.getParameter("callback");
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            String jsonRes = BJsonUtil.toJsonString(httpResContent);
            String retStr = e + "(" + jsonRes + ")";
            PrintWriter pw = response.getWriter();
            pw.write(retStr);
            pw.close();
            pw.flush();
        }
        catch (Exception var8) {
            logger.error((Object)var8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject sendHttpPostRequest(String url, JSONObject params) {
        JSONObject retJson = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();
            HttpPost e = new HttpPost(url);
            StringEntity entity = new StringEntity(BHttpResUtil.getPostParamStrFromJSONObject(params), ContentType.create((String)"application/x-www-form-urlencoded", (String)"UTF-8"));
            e.setEntity((HttpEntity)entity);
            retJson = BHttpResUtil.sendRequestAndGetResponseJsonData(httpClient, (HttpUriRequest)e);
        }
        catch (Exception var9) {
            logger.error((Object)("POST\u8bf7\u6c42\u5931\u8d25,URL:" + url), (Throwable)var9);
        }
        finally {
            BHttpResUtil.closeHttpClient(httpClient);
        }
        return retJson;
    }

    public static String sendHttpPostRequest(String url, String xmlString) {
        try {
            CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(xmlString, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            CloseableHttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                return EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            }
            closeableHttpClient.close();
        }
        catch (Exception var9) {
            logger.error((Object)("POST\u8bf7\u6c42\u5931\u8d25,URL:" + url), (Throwable)var9);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject sendHttpGetRequest(String url) {
        JSONObject jsonResult = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();
            HttpGet e = new HttpGet(url);
            jsonResult = BHttpResUtil.sendRequestAndGetResponseJsonData(httpClient, (HttpUriRequest)e);
        }
        catch (Exception var7) {
            logger.error((Object)("GET\u8bf7\u6c42\u5931\u8d25,URL:" + url), (Throwable)var7);
        }
        finally {
            BHttpResUtil.closeHttpClient(httpClient);
        }
        return jsonResult;
    }

    private static String getPostParamStrFromJSONObject(JSONObject jsonObj) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : jsonObj.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append((String)entry.getKey() + "=" + entry.getValue());
        }
        return sb.toString();
    }

    private static JSONObject sendRequestAndGetResponseJsonData(CloseableHttpClient chc, HttpUriRequest hur) throws Exception {
        CloseableHttpResponse response = chc.execute(hur);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new Exception("GET\u8bf7\u6c42\u8fd4\u56de\u72b6\u6001\u5f02\u5e38,\u72b6\u6001\u7801:" + statusCode);
        }
        return JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
    }

    private static void closeHttpClient(CloseableHttpClient chc) {
        if (chc != null) {
            try {
                chc.close();
            }
            catch (IOException var2) {
                logger.error((Object)"httpClient\u5bf9\u8c61\u5173\u95ed\u5f02\u5e38", (Throwable)var2);
            }
        }
    }

    public static JSONObject sendSSLPostRequest(String url, String params) {
        return BHttpResUtil.sendSSLRequest(url, params, "post");
    }

    public static JSONObject sendSSLGetRequest(String url) {
        return BHttpResUtil.sendSSLRequest(url, null, "get");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject sendSSLRequest(String url, String params, String methodType) {
        JSONObject retJson = null;
        try {
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            HttpsURLConnection httpUrlConn = (HttpsURLConnection)new URL(url).openConnection();
            httpUrlConn.setSSLSocketFactory(sslContext.getSocketFactory());
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestMethod(methodType.toUpperCase());
            if (methodType.equalsIgnoreCase("get")) {
                httpUrlConn.connect();
            }
            if (StringUtils.isNotBlank((String)params)) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(params.getBytes("UTF-8"));
                outputStream.close();
            }
            String retStr = IOUtils.toString((InputStream)httpUrlConn.getInputStream(), (String)"UTF-8");
            retJson = JSONObject.parseObject((String)retStr);
            httpUrlConn.disconnect();
        }
        catch (ConnectException ce) {
            logger.error((Object)"\u53d1\u9001\u8bf7\u6c42\u8d85\u65f6!", (Throwable)ce);
        }
        catch (Exception e) {
            logger.error((Object)"\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38!", (Throwable)e);
        }
        finally {
            return retJson;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject sendHttpFilePostRequest(String urlStr, JSONObject params) throws Exception {
        String BOUNDARY = "----MyFormBoundarySMFEtUYQG6r5B920";
        HttpURLConnection hc = null;
        String retStr = null;
        try {
            URL url = new URL(urlStr);
            hc = (HttpURLConnection)url.openConnection();
            hc.setRequestProperty("Content-Type", "multipart/form-data; boundary=----MyFormBoundarySMFEtUYQG6r5B920");
            hc.setRequestProperty("Charsert", "UTF-8");
            hc.setDoOutput(true);
            hc.setDoInput(true);
            hc.setUseCaches(false);
            hc.setRequestMethod("POST");
            OutputStream dout = hc.getOutputStream();
            String boundary = "----MyFormBoundarySMFEtUYQG6r5B920";
            StringBuffer resSB = new StringBuffer("\r\n");
            String endBoundary = "\r\n--" + boundary + "--\r\n";
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                String value = entry.getValue().toString();
                if (!StringUtils.isNotBlank((String)key)) continue;
                resSB.append(String.format("Content-Disposition: form-data; name=%s\r\n\r\n%s\r\n--%s\r\n", key, value, boundary));
            }
            String boundaryMessage = resSB.toString();
            dout.write(("--" + boundary + boundaryMessage).getBytes("UTF-8"));
            resSB = new StringBuffer();
            resSB.append("Content-Disposition: form-data; name=Filedata; filename=class_img.jpg\r\nContent-Type: image/jpeg\r\n\r\n");
            dout.write(resSB.toString().getBytes("UTF-8"));
            URL fileUrl = new URL(params.getString("file"));
            DataInputStream in = new DataInputStream(fileUrl.openConnection().getInputStream());
            dout.write(IOUtils.toByteArray((InputStream)in));
            in.close();
            dout.write(endBoundary.getBytes("UTF-8"));
            dout.close();
            retStr = IOUtils.toString((InputStream)hc.getInputStream(), (String)"UTF-8");
        }
        catch (Exception e) {
            logger.error((Object)"\u53d1\u9001\u8bf7\u6c42\u5931\u8d25!", (Throwable)e);
        }
        finally {
            try {
                hc.disconnect();
            }
            catch (Exception e2) {
                logger.error((Object)"\u53d1\u9001\u8bf7\u6c42\u5931\u8d25!", (Throwable)e2);
            }
        }
        return JSONObject.parseObject(retStr);
    }
}

