package net.oschina.suyeer.basic.util;

import com.alibaba.fastjson.JSONObject;
import net.oschina.suyeer.basic.bean.BHttpResContent;
import net.oschina.suyeer.basic.bean.MyX509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;

import static net.oschina.suyeer.basic.util.BConstUtil.DEFAULT_ENCODE;
import static net.oschina.suyeer.basic.util.BConstUtil.FILE;

/**
 * Created by jun on 2017/2/16.
 */
public class BHttpResUtil {
    private static Logger logger = Logger.getLogger(BHttpResUtil.class);

    public static <T> void writeResResult(BHttpResContent<T> httpResContent, HttpServletResponse response) {
        try {
            if (response == null) {
                throw new IllegalArgumentException("parameter error.");
            } else {
                response.setContentType(BConstUtil.CONTENT_TYPE_APPLICATION_JSON);
                response.setCharacterEncoding(DEFAULT_ENCODE);
                String jsonRes = BJsonUtil.toJsonString(httpResContent);
                PrintWriter pw = response.getWriter();
                pw.write(jsonRes);
                pw.close();
                pw.flush();
            }
        } catch (Exception var5) {
            logger.error(var5);
        }
    }

    public static <T> void writeResResult4Jsonp(BHttpResContent<T> httpResContent, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (request != null && response != null) {
                String e = request.getParameter("callback");
                response.setContentType(BConstUtil.CONTENT_TYPE_APPLICATION_JSON);
                response.setCharacterEncoding(DEFAULT_ENCODE);
                String jsonRes = BJsonUtil.toJsonString(httpResContent);
                String retStr = e + "(" + jsonRes + ")";
                PrintWriter pw = response.getWriter();
                pw.write(retStr);
                pw.close();
                pw.flush();
            } else {
                throw new IllegalArgumentException("parameter error.");
            }
        } catch (Exception var8) {
            logger.error(var8);
        }
    }

    public static JSONObject sendHttpPostRequest(String url, JSONObject params) {
        JSONObject retJson = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();
            HttpPost e = new HttpPost(url);
            StringEntity entity = new StringEntity(getPostParamStrFromJSONObject(params), ContentType.create("application/x-www-form-urlencoded", DEFAULT_ENCODE));
            e.setEntity(entity);
            retJson = sendRequestAndGetResponseJsonData(httpClient, e);
        } catch (Exception var9) {
            logger.error("POST请求失败,URL:" + url, var9);
        } finally {
            closeHttpClient(httpClient);
        }
        return retJson;
    }

    public static String sendHttpPostRequest(String url, String xmlString) {
        try {
            CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(xmlString, DEFAULT_ENCODE);
            httpPost.setEntity(entity);
            HttpResponse httpResponse = closeableHttpClient.execute(httpPost);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                return EntityUtils.toString(httpEntity, DEFAULT_ENCODE);
            }
            closeableHttpClient.close();
        } catch (Exception var9) {
            logger.error("POST请求失败,URL:" + url, var9);
        }
        return null;
    }

    public static JSONObject sendHttpGetRequest(String url) {
        JSONObject jsonResult = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();
            HttpGet e = new HttpGet(url);
            jsonResult = sendRequestAndGetResponseJsonData(httpClient, e);
        } catch (Exception var7) {
            logger.error("GET请求失败,URL:" + url, var7);
        } finally {
            closeHttpClient(httpClient);
        }
        return jsonResult;
    }

    private static String getPostParamStrFromJSONObject(JSONObject jsonObj) {
        StringBuilder sb = new StringBuilder();
        Map.Entry entry;
        for (Iterator i$ = jsonObj.entrySet().iterator(); i$.hasNext(); sb.append((String) entry.getKey() + "=" + entry.getValue())) {
            entry = (Map.Entry) i$.next();
            if (sb.length() > 0) {
                sb.append("&");
            }
        }
        return sb.toString();
    }

    private static JSONObject sendRequestAndGetResponseJsonData(CloseableHttpClient chc, HttpUriRequest hur) throws Exception {
        CloseableHttpResponse response = chc.execute(hur);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new Exception("GET请求返回状态异常,状态码:" + statusCode);
        } else {
            return JSONObject.parseObject(EntityUtils.toString(response.getEntity(), DEFAULT_ENCODE));
        }
    }

    private static void closeHttpClient(CloseableHttpClient chc) {
        if (chc != null) {
            try {
                chc.close();
            } catch (IOException var2) {
                logger.error("httpClient对象关闭异常", var2);
            }
        }
    }

    public static JSONObject sendSSLPostRequest(String url, String params) {
        return sendSSLRequest(url, params, "post");
    }

    public static JSONObject sendSSLGetRequest(String url) {
        return sendSSLRequest(url, null, "get");
    }

    private static JSONObject sendSSLRequest(String url, String params, String methodType) {
        JSONObject retJson = null;
        try {
            TrustManager[] tm = {new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new java.security.SecureRandom());
            HttpsURLConnection httpUrlConn = (HttpsURLConnection) (new URL(url).openConnection());
            httpUrlConn.setSSLSocketFactory(sslContext.getSocketFactory());
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestMethod(methodType.toUpperCase());
            if (methodType.equalsIgnoreCase("get"))
                httpUrlConn.connect();
            if (StringUtils.isNotBlank(params)) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(params.getBytes(DEFAULT_ENCODE));
                outputStream.close();
            }
            String retStr = IOUtils.toString(httpUrlConn.getInputStream(), DEFAULT_ENCODE);
            retJson = JSONObject.parseObject(retStr);
            httpUrlConn.disconnect();
        } catch (ConnectException ce) {
            logger.error("发送请求超时!", ce);
        } catch (Exception e) {
            logger.error("发送请求异常!", e);
        } finally {
            return retJson;
        }
    }

    /**
     * 发送包含文件的post请求(未完成)
     *
     * @param urlStr
     * @param params
     * @return
     * @throws Exception
     */
    public static JSONObject sendHttpFilePostRequest(String urlStr, JSONObject params) throws Exception {
        final String BOUNDARY = "----MyFormBoundarySMFEtUYQG6r5B920";
        HttpURLConnection hc = null;
        String retStr = null;
        try {
            URL url = new URL(urlStr);
            hc = (HttpURLConnection) url.openConnection();
            hc.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            hc.setRequestProperty("Charsert", DEFAULT_ENCODE);
            hc.setDoOutput(true);
            hc.setDoInput(true);
            hc.setUseCaches(false);
            hc.setRequestMethod("POST");

            OutputStream dout = hc.getOutputStream();
            //1.先写文字形式的post流
            String boundary = BOUNDARY;
            StringBuffer resSB = new StringBuffer("\r\n");
            String endBoundary = "\r\n--" + boundary + "--\r\n";
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue().toString();
                if (StringUtils.isNotBlank(key)) {
                    resSB.append(String.format("Content-Disposition: form-data; name=%s\r\n\r\n%s\r\n--%s\r\n", key, value, boundary));
                }
            }
            String boundaryMessage = resSB.toString();
            dout.write(("--" + boundary + boundaryMessage).getBytes(DEFAULT_ENCODE));
            //2.再写文件开式的post流
            resSB = new StringBuffer();
            resSB.append("Content-Disposition: form-data; name=Filedata; filename=class_img.jpg\r\nContent-Type: image/jpeg\r\n\r\n");
            dout.write(resSB.toString().getBytes(DEFAULT_ENCODE));
            URL fileUrl = new URL(params.getString(FILE));
            DataInputStream in = new DataInputStream(fileUrl.openConnection().getInputStream());
            dout.write(IOUtils.toByteArray(in));
            in.close();
            //3.最后写结尾
            dout.write(endBoundary.getBytes(DEFAULT_ENCODE));
            dout.close();
            retStr = IOUtils.toString(hc.getInputStream(), DEFAULT_ENCODE);
        } catch (Exception e) {
            logger.error("发送请求失败!", e);
        } finally {
            try {
                hc.disconnect();
            } catch (Exception e2) {
                logger.error("发送请求失败!", e2);
            }
        }
        return JSONObject.parseObject(retStr);
    }
}
