package net.oschina.suyeer.basic.util;

import com.alibaba.fastjson.JSONObject;
import net.oschina.suyeer.basic.bean.BHttpResContent;
import net.oschina.suyeer.basic.bean.MyX509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;

/**
 * Created by jun on 2017/2/16.
 */
public class BHttpResUtil {
    private static Logger logger = Logger.getLogger(BHttpResUtil.class);
    private static Boolean ENABLE_JSONP_REQUEST = Boolean.valueOf(false);

    public BHttpResUtil() {
    }

    public static <T> void writeResContent(BHttpResContent<T> httpResContent, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (ENABLE_JSONP_REQUEST.booleanValue()) {
                writeResResult4Jsonp(httpResContent, request, response);
            } else {
                writeResResult(httpResContent, response);
            }
        } catch (Exception var4) {
            logger.error(var4.getMessage());
        }

    }

    public static <T> void writeResResult(BHttpResContent<T> httpResContent, HttpServletResponse response) throws Exception {
        try {
            if (response == null) {
                throw new IllegalArgumentException("parameter error.");
            } else {
                response.setContentType(BConstUtil.CONTENT_TYPE_APPLICATION_JSON);
                response.setCharacterEncoding(BConstUtil.DEFAULT_ENCODE);
                String jsonRes = BJsonUtil.toJsonString(httpResContent);
                PrintWriter pw = response.getWriter();
                pw.write(jsonRes);
                pw.close();
                pw.flush();
            }
        } catch (Exception var5) {
            throw new Exception(var5);
        }
    }

    public static <T> void writeResResult4Jsonp(BHttpResContent<T> httpResContent, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            if (request != null && response != null) {
                String e = request.getParameter("callback");
                response.setContentType(BConstUtil.CONTENT_TYPE_APPLICATION_JSON);
                response.setCharacterEncoding(BConstUtil.DEFAULT_ENCODE);
                String jsonRes = BJsonUtil.toJsonString(httpResContent);
                String retJsonpS = e + "(" + jsonRes + ")";
                PrintWriter pw = response.getWriter();
                pw.write(retJsonpS);
                pw.close();
                pw.flush();
            } else {
                throw new IllegalArgumentException("parameter error.");
            }
        } catch (Exception var8) {
            throw new Exception(var8);
        }
    }

    public static JSONObject sendHttpPostRequest(String url, JSONObject params) {
        JSONObject jsonResult = null;
        CloseableHttpClient httpClient = null;

        try {
            httpClient = HttpClients.createDefault();
            HttpPost e = new HttpPost(url);
            StringEntity entity = new StringEntity(getPostParamStrFromJSONObject(params), ContentType.create("application/x-www-form-urlencoded", "UTF-8"));
            e.setEntity(entity);
            jsonResult = sendRequestAndGetResponseJsonData(httpClient, e);
        } catch (Exception var9) {
            logger.error("POST请求失败,URL:" + url, var9);
        } finally {
            closeHttpClient(httpClient);
        }

        return jsonResult;
    }

    public static JSONObject sendHttpGetRequest(String url) {
        JSONObject jsonResult = null;
        CloseableHttpClient httpClient = null;

        try {
            httpClient = HttpClients.createDefault();
            HttpGet e = new HttpGet(url);
            jsonResult = sendRequestAndGetResponseJsonData(httpClient, e);
        } catch (Exception var7) {
            logger.error("GET请求失败,URL:" + url, var7);
        } finally {
            closeHttpClient(httpClient);
        }

        return jsonResult;
    }

    private static String getPostParamStrFromJSONObject(JSONObject jsonObj) {
        StringBuilder sb = new StringBuilder();

        Map.Entry entry;
        for (Iterator i$ = jsonObj.entrySet().iterator(); i$.hasNext(); sb.append((String) entry.getKey() + "=" + entry.getValue())) {
            entry = (Map.Entry) i$.next();
            if (sb.length() > 0) {
                sb.append("&");
            }
        }

        return sb.toString();
    }

    private static JSONObject sendRequestAndGetResponseJsonData(CloseableHttpClient chc, HttpUriRequest hur) throws Exception {
        CloseableHttpResponse response = chc.execute(hur);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new Exception("GET请求返回状态异常,状态码:" + statusCode);
        } else {
            return JSONObject.parseObject(EntityUtils.toString(response.getEntity(), BConstUtil.DEFAULT_ENCODE));
        }
    }

    private static void closeHttpClient(CloseableHttpClient chc) {
        if (chc != null) {
            try {
                chc.close();
            } catch (IOException var2) {
                logger.error("httpClient对象关闭异常");
            }
        }

    }

    public static JSONObject sendSSLPostRequest(String url, String params) {
        return sendSSLRequest(url, params, "post");
    }

    public static JSONObject sendSSLGetRequest(String url) {
        return sendSSLRequest(url, null, "get");
    }

    private static JSONObject sendSSLRequest(String url, String params, String methodType) {
        JSONObject retJson = null;
        try {
            // 创建SSLContext对象，并使用我们指定的信任管理器初始化
            TrustManager[] tm = {new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new java.security.SecureRandom());
            // 从上述SSLContext对象中得到SSLSocketFactory对象
            HttpsURLConnection httpUrlConn = (HttpsURLConnection) (new URL(url).openConnection());
            httpUrlConn.setSSLSocketFactory(sslContext.getSocketFactory());
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            // 设置请求方式（GET/POST）
            httpUrlConn.setRequestMethod(methodType.toUpperCase());
            if (methodType.equalsIgnoreCase("get"))
                httpUrlConn.connect();
            // 当有数据需要提交时
            if (StringUtils.isNotBlank(params)) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(params.getBytes(BConstUtil.DEFAULT_ENCODE));
                outputStream.close();
            }
            // 将返回的输入流转换成字符串
            String ss = IOUtils.toString(httpUrlConn.getInputStream(), BConstUtil.DEFAULT_ENCODE);
            retJson = JSONObject.parseObject(ss);
            // close connection.
            httpUrlConn.disconnect();
        } catch (ConnectException ce) {
            logger.error("发送请求超时 ：" + ce.getMessage());
        } catch (Exception e) {
            logger.error("发送请求异常 : {}", e);
        } finally {
            return retJson;
        }
    }
}
