/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.taglib;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Pager<T> {
    int page = 1;
    int rows = 60;
    private String orderBy;
    private List<T> result = Collections.emptyList();
    private int count;
    private int pagecount;
    private int prev;
    private int next;
    private String uri;
    private Map<String, String> query;

    public Pager() {
    }

    public Pager(int curpage) {
        this.page = curpage;
    }

    private void calculate() {
        this.pagecount = (this.count + this.rows - 1) / this.rows;
        this.prev = this.page <= 1 ? 0 : this.page - 1;
        this.next = this.page >= this.pagecount ? 0 : this.page + 1;
    }

    public void setResult(List<T> result) {
        this.result = result;
    }

    public void setCount(int count) {
        this.count = count;
        if (count > 0) {
            this.calculate();
        }
    }

    public void sePage(int curpage) {
        this.page = curpage;
        this.calculate();
    }

    public void setPagecount(int pagecount) {
        this.pagecount = pagecount;
    }

    public void setPrev(int prev) {
        this.prev = prev;
    }

    public void setNext(int next) {
        this.next = next;
    }

    public List<T> getResult() {
        return this.result;
    }

    public int getCount() {
        return this.count;
    }

    public int getPagecount() {
        return this.pagecount;
    }

    public int getPrev() {
        return this.prev;
    }

    public int getNext() {
        return this.next;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Map<String, String> getQuery() {
        return this.query;
    }

    public void setQuery(Map<String, String> query) {
        this.query = query;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String toString() {
        return "page=" + this.page + ",pagesize=" + this.rows + ",count=" + this.count;
    }
}

