/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.support;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinYin4J {
    public static String getPinyin(String chinese) {
        return PinYin4J.getPinyinZh_CN(PinYin4J.makeStringByStringSet(chinese));
    }

    public static String getPinyinToUpperCase(String chinese) {
        return PinYin4J.getPinyinZh_CN(PinYin4J.makeStringByStringSet(chinese)).toUpperCase();
    }

    public static String getPinyinToLowerCase(String chinese) {
        return PinYin4J.getPinyinZh_CN(PinYin4J.makeStringByStringSet(chinese)).toLowerCase();
    }

    public static String getPinyinFirstToUpperCase(String chinese) {
        return PinYin4J.getPinyin(chinese);
    }

    public static String getPinyinJianPin(String chinese) {
        return PinYin4J.getPinyinConvertJianPin(PinYin4J.getPinyin(chinese));
    }

    public static Set<String> makeStringByStringSet(String chinese) {
        char[] chars = chinese.toCharArray();
        if (chinese != null && !chinese.trim().equalsIgnoreCase("")) {
            char[] srcChar = chinese.toCharArray();
            String[][] temp = new String[chinese.length()][];
            for (int i = 0; i < srcChar.length; ++i) {
                char c = srcChar[i];
                if (String.valueOf(c).matches("[\\u4E00-\\u9FA5]+")) {
                    try {
                        temp[i] = PinyinHelper.toHanyuPinyinStringArray((char)chars[i], (HanyuPinyinOutputFormat)PinYin4J.getDefaultOutputFormat());
                    }
                    catch (BadHanyuPinyinOutputFormatCombination e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                temp[i] = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' ? new String[]{String.valueOf(srcChar[i])} : new String[]{""};
            }
            String[] pingyinArray = PinYin4J.Exchange(temp);
            HashSet<String> zhongWenPinYin = new HashSet<String>();
            for (int i = 0; i < pingyinArray.length; ++i) {
                zhongWenPinYin.add(pingyinArray[i]);
            }
            return zhongWenPinYin;
        }
        return null;
    }

    public static HanyuPinyinOutputFormat getDefaultOutputFormat() {
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        format.setVCharType(HanyuPinyinVCharType.WITH_U_AND_COLON);
        return format;
    }

    public static String[] Exchange(String[][] strJaggedArray) {
        String[][] temp = PinYin4J.DoExchange(strJaggedArray);
        return temp[0];
    }

    private static String[][] DoExchange(String[][] strJaggedArray) {
        int len = strJaggedArray.length;
        if (len >= 2) {
            int len1 = strJaggedArray[0].length;
            int len2 = strJaggedArray[1].length;
            int newlen = len1 * len2;
            String[] temp = new String[newlen];
            int Index = 0;
            for (int i = 0; i < len1; ++i) {
                for (int j = 0; j < len2; ++j) {
                    temp[Index] = PinYin4J.capitalize(strJaggedArray[0][i]) + PinYin4J.capitalize(strJaggedArray[1][j]);
                    ++Index;
                }
            }
            String[][] newArray = new String[len - 1][];
            for (int i = 2; i < len; ++i) {
                newArray[i - 1] = strJaggedArray[i];
            }
            newArray[0] = temp;
            return PinYin4J.DoExchange(newArray);
        }
        return strJaggedArray;
    }

    public static String capitalize(String s) {
        char[] ch = s.toCharArray();
        if (ch[0] >= 'a' && ch[0] <= 'z') {
            ch[0] = (char)(ch[0] - 32);
        }
        String newString = new String(ch);
        return newString;
    }

    public static String getPinyinZh_CN(Set<String> stringSet) {
        StringBuilder str = new StringBuilder();
        int i = 0;
        for (String s : stringSet) {
            if (i == stringSet.size() - 1) {
                str.append(s);
            } else {
                str.append(s + ",");
            }
            ++i;
        }
        return str.toString();
    }

    public static String getPinyinConvertJianPin(String chinese) {
        String[] strArray = chinese.split(",");
        String strChar = "";
        for (String str : strArray) {
            char[] arr = str.toCharArray();
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] < 'A' || arr[i] >= '[') continue;
                strChar = strChar + new String(arr[i] + "");
            }
            strChar = strChar + ",";
        }
        return strChar;
    }

    public static void main(String[] args) {
        String str = "\u957f\u6c99\u5e02";
        System.out.println("\u5c0f\u5199\u8f93\u51fa\uff1a" + PinYin4J.getPinyinToLowerCase(str));
        System.out.println("\u5927\u5199\u8f93\u51fa\uff1a" + PinYin4J.getPinyinToUpperCase(str));
        System.out.println("\u9996\u5b57\u6bcd\u5927\u5199\u8f93\u51fa\uff1a" + PinYin4J.getPinyinFirstToUpperCase(str));
        System.out.println("\u7b80\u62fc\u8f93\u51fa\uff1a" + PinYin4J.getPinyinJianPin(str));
    }
}

