/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import jmind.base.util.DateUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtils;

public class MethodSupport {
    public static String getProperty(Object bean, String name) {
        try {
            return BeanUtils.getProperty((Object)bean, (String)name);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object getPropertyValue(Object bean, String name) {
        try {
            return BeanUtilsBean.getInstance().getPropertyUtils().getProperty(bean, name);
        }
        catch (Exception e) {
            try {
                return PropertyUtils.getProperty((Object)bean, (String)name);
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
            return null;
        }
    }

    public static void setProperty(Object bean, String name, Object value) {
        try {
            BeanUtils.setProperty((Object)bean, (String)name, (Object)value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static String[] getMethodParamNames(Class<?> clazz, String method) throws Exception {
        ClassPool pool = ClassPool.getDefault();
        CtClass cc = pool.get(clazz.getName());
        CtMethod cm = cc.getDeclaredMethod(method);
        return MethodSupport.getMethodParamNames(cm);
    }

    protected static String[] getMethodParamNames(CtMethod cm) throws Exception {
        MethodInfo methodInfo = cm.getMethodInfo();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        LocalVariableAttribute attr = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        if (attr == null) {
            return null;
        }
        String[] paramNames = new String[cm.getParameterTypes().length];
        int pos = Modifier.isStatic(cm.getModifiers()) ? 0 : 1;
        for (int i = 0; i < paramNames.length; ++i) {
            paramNames[i] = attr.variableName(i + pos);
        }
        return paramNames;
    }

    public static <T> T map2Object(Map<String, Object> map, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        T obj = clazz.newInstance();
        for (String name : map.keySet()) {
            Class type = null;
            try {
                type = PropertyUtils.getPropertyType(obj, (String)name);
                if (type == null) continue;
                PropertyUtils.setProperty(obj, (String)name, (Object)ConvertUtils.convert((Object)map.get(name), (Class)type));
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    public static <T> T mapStr2Object(Map<String, String> map, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        T obj = clazz.newInstance();
        for (String name : map.keySet()) {
            try {
                BeanUtils.setProperty(obj, (String)name, (Object)map.get(name));
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    static {
        ConvertUtils.register((Converter)new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                if (value instanceof String) {
                    return (T)DateUtil.parse((String)value.toString());
                }
                return type.cast(value);
            }
        }, Date.class);
        ConvertUtils.register((Converter)new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                if (value instanceof Date) {
                    return (T)DateUtil.format((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss");
                }
                return type.cast(value.toString());
            }
        }, String.class);
    }
}

