/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.support;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jmind.base.lang.Pair;
import jmind.base.util.DataUtil;
import jmind.core.http.HttpClient;
import jmind.core.log.LogUtil;
import org.slf4j.Logger;

public class HttpUtil {
    private static final Logger logger = LogUtil.getLogger(HttpUtil.class);
    private static final HttpClient client = HttpClient.getHttpClient();

    public static void main(String[] args) {
        String s = "{\"name\":\"wave\",\"pwd\":\"abcd\"}";
        HashMap props = Maps.newHashMap();
        props.put("Content-Type", "application/json");
        String a = HttpUtil.sendPost("http://localhost:8081/lady", s, props);
        System.err.println(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPost(String urlString, String content, Map<String, String> props) {
        long start = System.currentTimeMillis();
        HttpURLConnection urlConnection = null;
        String res = null;
        try {
            URL url = new URL(urlString);
            urlConnection = (HttpURLConnection)url.openConnection();
            if (!DataUtil.isEmpty(props)) {
                for (Map.Entry<String, String> entry : props.entrySet()) {
                    urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            urlConnection.setConnectTimeout(1000);
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.getOutputStream().write(content.getBytes("UTF-8"));
            urlConnection.getOutputStream().flush();
            urlConnection.getOutputStream().close();
            InputStream in = urlConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
            String line = bufferedReader.readLine();
            StringBuilder builder = new StringBuilder();
            while (line != null) {
                builder.append(line);
                line = bufferedReader.readLine();
            }
            res = builder.toString();
        }
        catch (Exception e) {
            try {
                logger.error(urlString, (Throwable)e);
            }
            catch (Throwable throwable) {
                long t = System.currentTimeMillis() - start;
                String slow = t > 200L ? "slow|" : "";
                logger.debug(slow + "t={},url={},res={}", new Object[]{t, urlString, res});
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                throw throwable;
            }
            long t = System.currentTimeMillis() - start;
            String slow = t > 200L ? "slow|" : "";
            logger.debug(slow + "t={},url={},res={}", new Object[]{t, urlString, res});
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        long t = System.currentTimeMillis() - start;
        String slow = t > 200L ? "slow|" : "";
        logger.debug(slow + "t={},url={},res={}", new Object[]{t, urlString, res});
        if (urlConnection != null) {
            urlConnection.disconnect();
        }
        return res;
    }

    public static final String get(String url) {
        return client.get(url, "UTF-8", 1000);
    }

    public static final String get(String url, String code, int timeout) {
        return client.get(url, code, timeout);
    }

    public static String post(String url, Map<String, ?> params) {
        return client.post(url, params);
    }

    public static String post(String url, List<Pair<String, String>> params, String code) {
        return client.post(url, params, code, 0);
    }

    public static String postFile(String url, Map<String, ?> params, String fileName, File file) {
        return client.postFile(url, params, fileName, file, "UTF-8");
    }
}

