/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.support;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import jmind.core.support.MethodSupport;

public class BeanProperty<T> {
    private Map<String, String> fields = new HashMap<String, String>();
    private Class<T> clazz;
    private T instance;

    public BeanProperty(Class<T> bean) {
        Field[] fs;
        this.clazz = bean;
        for (Field f : fs = bean.getDeclaredFields()) {
            this.fields.put(f.getName().toLowerCase(), f.getName());
        }
        try {
            this.instance = bean.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public String getFieldName(String name) {
        return this.fields.get(name.toLowerCase());
    }

    public Field getField(String name) throws SecurityException, NoSuchFieldException {
        return this.clazz.getField(this.getFieldName(name));
    }

    public void setProperty(String name, Object value) {
        MethodSupport.setProperty(this.instance, this.getFieldName(name), value);
    }

    public Object getProperty(String name) {
        return MethodSupport.getPropertyValue(this.instance, this.getFieldName(name));
    }

    public T get() {
        return this.instance;
    }
}

